/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.BlockEntityDarkTank;
import org.cyclops.evilcraft.client.render.model.ModelDarkTankBaked;
import org.jetbrains.annotations.Nullable;

public class RenderBlockEntityDarkTank
implements BlockEntityRenderer<BlockEntityDarkTank, RenderState> {
    private static final float OFFSET = 0.01f;
    private static final float MINY = 0.01f;
    private static final float MIN = 0.135f;
    private static final float MAX = 0.865f;
    private static float[][][] coordinates = new float[][][]{new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.135f}}, new float[][]{{0.135f, 0.865f, 0.135f}, {0.135f, 0.865f, 0.865f}, {0.865f, 0.865f, 0.865f}, {0.865f, 0.865f, 0.135f}}, new float[][]{{0.135f, 0.01f, 0.135f}, {0.135f, 0.865f, 0.135f}, {0.865f, 0.865f, 0.135f}, {0.865f, 0.01f, 0.135f}}, new float[][]{{0.135f, 0.865f, 0.865f}, {0.135f, 0.01f, 0.865f}, {0.865f, 0.01f, 0.865f}, {0.865f, 0.865f, 0.865f}}, new float[][]{{0.135f, 0.865f, 0.135f}, {0.135f, 0.01f, 0.135f}, {0.135f, 0.01f, 0.865f}, {0.135f, 0.865f, 0.865f}}, new float[][]{{0.865f, 0.01f, 0.135f}, {0.865f, 0.865f, 0.135f}, {0.865f, 0.865f, 0.865f}, {0.865f, 0.01f, 0.865f}}};

    public RenderBlockEntityDarkTank(BlockEntityRendererProvider.Context context) {
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntityDarkTank blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.fluid = blockEntity.getTank().getFluid();
        renderState.enabled = blockEntity.isEnabled();
        renderState.fillRatio = blockEntity.getFillRatio();
    }

    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        FluidStack fluid = renderState.fluid;
        IModHelpersNeoForge.get().getRenderHelpers().renderFluidContext(fluid, poseStack, () -> {
            float height = (float)(renderState.fillRatio * (double)0.99f);
            int brightness = Math.max(renderState.lightCoords, fluid.getFluid().getFluidType().getLightLevel(fluid));
            RenderBlockEntityDarkTank.renderFluidSides(height, renderState.fluid, renderState.enabled, brightness, poseStack, submitNodeCollector);
        });
    }

    public static void renderFluidSides(float height, FluidStack fluid, boolean flowing, int brightness, PoseStack matrixStackIn, SubmitNodeCollector submitNodeCollector) {
        int l2 = brightness >> 16 & 0xFFFF;
        int i3 = brightness & 0xFFFF;
        Triple colorParts = IModHelpersNeoForge.get().getRenderHelpers().getFluidVertexBufferColor(fluid);
        float r = ((Float)colorParts.getLeft()).floatValue();
        float g = ((Float)colorParts.getMiddle()).floatValue();
        float b = ((Float)colorParts.getRight()).floatValue();
        float a = 1.0f;
        for (Direction side : DirectionHelpers.DIRECTIONS) {
            TextureAtlasSprite icon = ModelDarkTankBaked.getFluidIcon(fluid, flowing, side);
            submitNodeCollector.submitCustomGeometry(matrixStackIn, RenderTypes.text((Identifier)icon.atlasLocation()), (pose, vb) -> {
                float[][] c = coordinates[side.ordinal()];
                float minV = icon.getV0();
                float maxV = (icon.getV1() - icon.getV0()) * height + icon.getV0();
                float minU = icon.getU0();
                float maxU = icon.getU1();
                if (side == Direction.WEST || side == Direction.SOUTH) {
                    float tmp = minV;
                    minV = maxV;
                    maxV = tmp;
                } else if (side == Direction.UP || side == Direction.DOWN) {
                    maxV = icon.getV1();
                }
                vb.addVertex(pose, c[0][0], RenderBlockEntityDarkTank.getHeight(side, c[0][1], height), c[0][2]).setColor(r, g, b, a).setUv(minU, maxV).setUv2(l2, i3);
                vb.addVertex(pose, c[1][0], RenderBlockEntityDarkTank.getHeight(side, c[1][1], height), c[1][2]).setColor(r, g, b, a).setUv(minU, minV).setUv2(l2, i3);
                vb.addVertex(pose, c[2][0], RenderBlockEntityDarkTank.getHeight(side, c[2][1], height), c[2][2]).setColor(r, g, b, a).setUv(maxU, minV).setUv2(l2, i3);
                vb.addVertex(pose, c[3][0], RenderBlockEntityDarkTank.getHeight(side, c[3][1], height), c[3][2]).setColor(r, g, b, a).setUv(maxU, maxV).setUv2(l2, i3);
            });
        }
    }

    private static float getHeight(Direction side, float height, float replaceHeight) {
        if (height == 0.865f) {
            return replaceHeight;
        }
        return height;
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public FluidStack fluid;
        public boolean enabled;
        public double fillRatio;
    }
}

