/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.block.BlockDisplayStand;
import org.cyclops.evilcraft.blockentity.BlockEntityDisplayStand;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RenderBlockEntityDisplayStand
implements BlockEntityRenderer<BlockEntityDisplayStand, RenderState> {
    private static final Map<Direction, Vector3f> ROTATIONS = ImmutableMap.builder().put((Object)Direction.NORTH, (Object)new Vector3f(270.0f, 0.0f, 0.0f)).put((Object)Direction.SOUTH, (Object)new Vector3f(90.0f, 0.0f, 0.0f)).put((Object)Direction.WEST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.EAST, (Object)new Vector3f(0.0f, 90.0f, 0.0f)).put((Object)Direction.UP, (Object)new Vector3f(180.0f, 180.0f, 0.0f)).put((Object)Direction.DOWN, (Object)new Vector3f(0.0f, 0.0f, 0.0f)).build();

    public RenderBlockEntityDisplayStand(BlockEntityRendererProvider.Context context) {
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntityDisplayStand blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.item = blockEntity.getInventory().getItem(0);
        renderState.level = blockEntity.getLevel();
        renderState.positiveDirection = blockEntity.getDirection() == Direction.AxisDirection.POSITIVE;
    }

    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!renderState.item.isEmpty()) {
            this.submitItem(poseStack, submitNodeCollector, renderState.level, renderState.item, (Direction)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(renderState.blockState, BlockDisplayStand.FACING, (Comparable)Direction.NORTH), (Boolean)IModHelpers.get().getBlockHelpers().getSafeBlockStateProperty(renderState.blockState, (Property)BlockDisplayStand.AXIS_X, (Comparable)Boolean.valueOf(true)), renderState.positiveDirection);
        }
    }

    private void submitItem(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, Level level, ItemStack itemStack, Direction facing, boolean axisX, boolean positiveDirection) {
        poseStack.pushPose();
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, itemStack, ItemDisplayContext.FIXED, level, null, 0);
        poseStack.translate(0.5f, 0.5f, 0.5f);
        if (itemStack.getItem() instanceof BlockItem) {
            poseStack.scale(0.6f, 0.6f, 0.6f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        } else if (itemStack.getItem() instanceof IBroom) {
            poseStack.scale(2.0f, 2.0f, 2.0f);
        } else if (!(itemStack.getItem() instanceof IBroom)) {
            poseStack.scale(0.5f, 0.5f, 0.5f);
            poseStack.translate(0.0f, 0.25f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        }
        Vector3f vec = ROTATIONS.get(facing);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(vec.x()));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(vec.y()));
        if (!axisX) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            if (!positiveDirection) {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            }
        } else if (positiveDirection) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        }
        renderState.submit(poseStack, submitNodeCollector, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public ItemStack item;
        public Level level;
        public boolean positiveDirection;
    }
}

