/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.BlockEntityEntangledChalice;
import org.jetbrains.annotations.Nullable;

public class RenderBlockEntityEntangledChalice
implements BlockEntityRenderer<BlockEntityEntangledChalice, RenderState> {
    public RenderBlockEntityEntangledChalice(BlockEntityRendererProvider.Context context) {
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntityEntangledChalice blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.fluid = blockEntity.getTank().getFluid();
        renderState.capacity = blockEntity.getTank().getCapacity();
        renderState.color = IModHelpersNeoForge.get().getRenderHelpers().getFluidVertexBufferColor(renderState.fluid);
    }

    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (!renderState.fluid.isEmpty()) {
            FluidStack fluid = renderState.fluid;
            IModHelpersNeoForge.get().getRenderHelpers().renderFluidContext(renderState.fluid, poseStack, () -> {
                float height = Math.min(0.95f, (float)fluid.getAmount() / (float)renderState.capacity) * 0.1875f + 0.8125f;
                int brightness = Math.max(renderState.lightCoords, fluid.getFluid().getFluidType().getLightLevel(fluid));
                int l2 = brightness >> 16 & 0xFFFF;
                int i3 = brightness & 0xFFFF;
                TextureAtlasSprite icon = IModHelpersNeoForge.get().getRenderHelpers().getFluidIcon(fluid, Direction.UP);
                Triple<Float, Float, Float> color = renderState.color;
                submitNodeCollector.submitCustomGeometry(poseStack, RenderTypes.text((Identifier)icon.atlasLocation()), (pose, vb) -> {
                    vb.addVertex(pose, 0.1875f, height, 0.1875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
                    vb.addVertex(pose, 0.1875f, height, 0.8125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
                    vb.addVertex(pose, 0.8125f, height, 0.8125f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
                    vb.addVertex(pose, 0.8125f, height, 0.1875f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
                });
            });
        }
    }

    public boolean shouldRender(BlockEntityEntangledChalice blockEntity, Vec3 cameraPos) {
        return blockEntity.getBlockPos() == BlockPos.ZERO || super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public FluidStack fluid;
        public int capacity;
        public Triple<Float, Float, Float> color;
    }
}

