/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.cyclops.evilcraft.blockentity.BlockEntityEnvironmentalAccumulator;
import org.cyclops.evilcraft.client.render.blockentity.RenderBlockEntityBeacon;
import org.cyclops.evilcraft.core.recipe.display.RecipeDisplayEnvironmentalAccumulator;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class RenderBlockEntityEnvironmentalAccumulator
extends RenderBlockEntityBeacon<BlockEntityEnvironmentalAccumulator, RenderState> {
    private static final int ITEM_SPIN_SPEED = 3;

    public RenderBlockEntityEnvironmentalAccumulator(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    @Override
    public void extractRenderState(BlockEntityEnvironmentalAccumulator blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPosition, breakProgress);
        renderState.movingItemY = blockEntity.getMovingItemY();
        renderState.level = blockEntity.getLevel();
        renderState.recipeDisplay = blockEntity.getRecipeDisplay();
    }

    @Override
    protected void submitBeacon(RenderState renderState, float partialTicks, PoseStack matrixStackIn, SubmitNodeCollector submitNodeCollector) {
        if (renderState.movingItemY != -1.0f) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(-0.5f, -0.5f + renderState.movingItemY, -0.5f);
            this.submitProcessingItem(matrixStackIn, submitNodeCollector, renderState.recipeDisplay, renderState.level, partialTicks);
            matrixStackIn.popPose();
        }
        super.submitBeacon(renderState, partialTicks, matrixStackIn, submitNodeCollector);
    }

    @Override
    protected boolean isInnerBeam(BlockEntityEnvironmentalAccumulator tile) {
        return tile.getMovingItemY() >= 0.0f;
    }

    private void submitProcessingItem(PoseStack matrixStackIn, SubmitNodeCollector submitNodeCollector, RecipeDisplayEnvironmentalAccumulator recipe, Level world, float partialTickTime) {
        if (recipe == null) {
            return;
        }
        ItemStack stack = recipe.inputIngredient().resolveForFirstStack(SlotDisplayContext.fromLevel((Level)world));
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, stack, ItemDisplayContext.FIXED, world, null, 0);
        double totalTickTime = (float)world.getGameTime() + partialTickTime;
        float angle = (float)(3.0 * (totalTickTime % 360.0));
        if (stack.getItem() instanceof BlockItem) {
            matrixStackIn.translate(1.0f, 0.675f, 1.0f);
            matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(angle));
        } else {
            matrixStackIn.translate(1.0f, 1.0f, 1.0f);
            matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(angle));
        }
        matrixStackIn.scale(0.5f, 0.5f, 0.5f);
        renderState.submit(matrixStackIn, submitNodeCollector, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
    }

    public static class RenderState
    extends RenderBlockEntityBeacon.RenderState {
        public float movingItemY;
        public RecipeDisplayEnvironmentalAccumulator recipeDisplay;
        public Level level;
    }
}

