/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.object.book.BookModel;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.blockentity.BlockEntityPurifier;
import org.cyclops.evilcraft.blockentity.tickaction.purifier.DisenchantPurifyAction;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class RenderBlockEntityPurifier
implements BlockEntityRenderer<BlockEntityPurifier, RenderState> {
    public static final Material TEXTURE_BLOOK = new Material(Sheets.CHEST_SHEET, Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"entity/blook"));
    private final MaterialSet materials;
    private final BookModel enchantmentBook;

    public RenderBlockEntityPurifier(BlockEntityRendererProvider.Context context) {
        this.materials = context.materials();
        this.enchantmentBook = new BookModel(context.bakeLayer(ModelLayers.BOOK));
    }

    public RenderState createRenderState() {
        return new RenderState();
    }

    public void extractRenderState(BlockEntityPurifier blockEntity, RenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        renderState.level = blockEntity.getLevel();
        renderState.additionalItem = blockEntity.getAdditionalItem();
        renderState.purifyItem = blockEntity.getPurifyItem();
        renderState.randomRotation = blockEntity.getRandomRotation();
        renderState.fluid = blockEntity.getTank().getFluid();
        renderState.capacity = blockEntity.getTank().getCapacity();
        renderState.partialTicks = partialTick;
        renderState.tickCount = blockEntity.tickCount;
        renderState.additionalRotation2 = blockEntity.additionalRotation2;
        renderState.additionalRotationPrev = blockEntity.additionalRotationPrev;
        renderState.oFlip = blockEntity.oFlip;
        renderState.flip = blockEntity.flip;
        renderState.oOpen = blockEntity.oOpen;
        renderState.open = blockEntity.open;
    }

    public void submit(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        ItemStack additionalItem = renderState.additionalItem;
        if (!additionalItem.isEmpty()) {
            if (additionalItem.getItem() == DisenchantPurifyAction.ALLOWED_BOOK.get() || additionalItem.getItem() == Items.ENCHANTED_BOOK) {
                this.renderBook(renderState, poseStack, submitNodeCollector, additionalItem, renderState.partialTicks);
            } else {
                this.renderAdditionalItem(renderState, poseStack, submitNodeCollector, additionalItem, renderState.partialTicks);
            }
        }
        poseStack.pushPose();
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        if (!renderState.purifyItem.isEmpty()) {
            this.renderItem(poseStack, submitNodeCollector, renderState.purifyItem, renderState.randomRotation, renderState.level);
        }
        poseStack.popPose();
        FluidStack fluid = renderState.fluid;
        IModHelpersNeoForge.get().getRenderHelpers().renderFluidContext(fluid, poseStack, () -> {
            float height = (float)((double)fluid.getAmount() * 0.7 / (double)renderState.capacity + 0.23 + 0.01);
            int brightness = Math.max(renderState.lightCoords, fluid.getFluid().getFluidType().getLightLevel(fluid));
            int l2 = brightness >> 16 & 0xFFFF;
            int i3 = brightness & 0xFFFF;
            TextureAtlasSprite icon = IModHelpersNeoForge.get().getRenderHelpers().getFluidIcon(fluid, Direction.UP);
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
            Triple color = IModHelpers.get().getBaseHelpers().intToRGB(renderProperties.getTintColor(fluid.getFluid().defaultFluidState(), (BlockAndTintGetter)renderState.level, renderState.blockPos));
            submitNodeCollector.submitCustomGeometry(poseStack, RenderTypes.text((Identifier)icon.atlasLocation()), (pose, vb1) -> {
                vb1.addVertex(pose, 0.0625f, height, 0.0625f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV1()).setUv2(l2, i3);
                vb1.addVertex(pose, 0.0625f, height, 0.9375f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU0(), icon.getV0()).setUv2(l2, i3);
                vb1.addVertex(pose, 0.9375f, height, 0.9375f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV0()).setUv2(l2, i3);
                vb1.addVertex(pose, 0.9375f, height, 0.0625f).setColor(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).setUv(icon.getU1(), icon.getV1()).setUv2(l2, i3);
            });
        });
    }

    private void renderItem(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, ItemStack itemStack, float rotation, Level level) {
        poseStack.pushPose();
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, itemStack, ItemDisplayContext.FIXED, level, null, 0);
        if (itemStack.getItem() instanceof BlockItem) {
            poseStack.translate(1.0f, 1.2f, 1.0f);
            poseStack.scale(0.6f, 0.6f, 0.6f);
        } else {
            poseStack.translate(1.0f, 1.2f, 1.0f);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(25.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(25.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        }
        renderState.submit(poseStack, submitNodeCollector, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }

    private void renderAdditionalItem(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        poseStack.pushPose();
        float tick = (float)renderState.tickCount.intValue() + partialTickTime;
        poseStack.translate(0.5f, 0.75f, 0.5f);
        poseStack.translate(0.0f, 0.1f + Mth.sin((double)(tick * 0.1f)) * 0.01f, 0.0f);
        if (itemStack.getItem() instanceof BlockItem) {
            poseStack.translate(1.0f, 0.675f, 1.0f);
        }
        for (speedUp = renderState.additionalRotation2.floatValue() - renderState.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = renderState.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation * 180.0f / (float)Math.PI));
        poseStack.translate(0.0f, 0.5f, 0.0f);
        if (!(itemStack.getItem() instanceof BlockItem)) {
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(25.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotation));
        }
        ItemStackRenderState renderStateItem = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderStateItem, itemStack, ItemDisplayContext.FIXED, null, null, 0);
        renderStateItem.submit(poseStack, submitNodeCollector, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
        poseStack.popPose();
    }

    private void renderBook(RenderState renderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, ItemStack itemStack, float partialTickTime) {
        float speedUp;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.75f, 0.5f);
        float tick = (float)renderState.tickCount.intValue() + partialTickTime;
        poseStack.translate(0.0f, 0.1f + Mth.sin((double)(tick * 0.1f)) * 0.01f, 0.0f);
        for (speedUp = renderState.additionalRotation2.floatValue() - renderState.additionalRotationPrev.floatValue(); speedUp >= (float)Math.PI; speedUp -= (float)Math.PI * 2) {
        }
        while (speedUp < (float)(-Math.PI)) {
            speedUp += (float)Math.PI * 2;
        }
        float rotation = renderState.additionalRotationPrev.floatValue() + speedUp * partialTickTime;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation * 180.0f / (float)Math.PI));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(80.0f));
        float f3 = Mth.lerp((float)partialTickTime, (float)renderState.oFlip, (float)renderState.flip);
        float f4 = Mth.frac((float)(f3 + 0.25f)) * 1.6f - 0.3f;
        float f5 = Mth.frac((float)(f3 + 0.75f)) * 1.6f - 0.3f;
        float f6 = Mth.lerp((float)partialTickTime, (float)renderState.oOpen, (float)renderState.open);
        this.enchantmentBook.setupAnim(new BookModel.State(rotation, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), f6));
        Material material = itemStack.getItem() == DisenchantPurifyAction.ALLOWED_BOOK.get() ? TEXTURE_BLOOK : EnchantTableRenderer.BOOK_TEXTURE;
        BookModel.State bookmodel$state = new BookModel.State(tick, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), renderState.open);
        submitNodeCollector.submitModel((Model)this.enchantmentBook, (Object)bookmodel$state, poseStack, material.renderType(RenderTypes::entitySolid), renderState.lightCoords, OverlayTexture.NO_OVERLAY, -1, this.materials.get(material), 0, renderState.breakProgress);
        poseStack.popPose();
    }

    public static class RenderState
    extends BlockEntityRenderState {
        public Level level;
        public ItemStack additionalItem;
        public ItemStack purifyItem;
        public float randomRotation;
        public FluidStack fluid;
        public int capacity;
        public float partialTicks;
        public Integer tickCount;
        public Float additionalRotation2;
        public Float additionalRotationPrev;
        public float oFlip;
        public float flip;
        public float oOpen;
        public float open;
    }
}

