/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.evilcraft.client.render.entity.RenderStateBroom;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.joml.Quaternionfc;

public class RenderBroom
extends EntityRenderer<EntityBroom, RenderStateBroom> {
    public RenderBroom(EntityRendererProvider.Context renderContext) {
        super(renderContext);
    }

    public RenderStateBroom createRenderState() {
        return new RenderStateBroom();
    }

    public void extractRenderState(EntityBroom entity, RenderStateBroom reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.yRotO = entity.yRotO;
        reusedState.xRotO = entity.xRotO;
        reusedState.yRot = entity.getYRot();
        reusedState.xRot = entity.getXRot();
        reusedState.broomStack = entity.getBroomStack();
    }

    protected ItemStack getItemStack(RenderStateBroom renderState) {
        return renderState.broomStack;
    }

    public void submit(RenderStateBroom renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        super.submit((EntityRenderState)renderState, poseStack, nodeCollector, cameraRenderState);
        poseStack.translate(0.0f, 0.2f, 0.0f);
        float rotationYaw = renderState.yRotO + (renderState.yRot - renderState.yRotO) * renderState.partialTick;
        float rotationPitch = renderState.xRotO + (renderState.xRot - renderState.xRotO) * renderState.partialTick;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotationYaw));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(rotationPitch));
        poseStack.scale(2.0f, 2.0f, 2.0f);
        ItemStackRenderState renderStateItemStack = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderStateItemStack, this.getItemStack(renderState), ItemDisplayContext.FIXED, (Level)Minecraft.getInstance().level, null, 0);
        renderStateItemStack.submit(poseStack, nodeCollector, 0xF000F0, OverlayTexture.NO_OVERLAY, 0);
    }
}

