/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.client.render.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.block.CustomUnbakedBlockStateModel;
import net.neoforged.neoforge.model.data.ModelData;
import org.cyclops.cyclopscore.client.model.DelegatingDynamicItemAndBlockModel;
import org.cyclops.cyclopscore.helper.ModelHelpers;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModelBoxOfEternalClosureBaked
extends DelegatingDynamicItemAndBlockModel {
    protected static final ItemTransforms TRANSFORMS = ModelHelpers.modifyDefaultTransforms((Map)ImmutableMap.of((Object)ItemDisplayContext.GUI, (Object)new ItemTransform((Vector3fc)new Vector3f(30.0f, 135.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.625f, 0.625f, 0.625f))));
    private final BlockStateModel boxModel;
    private final BlockStateModel boxLidModel;
    private final BlockStateModel boxLidRotatedModel;
    private final boolean isOpen;

    public ModelBoxOfEternalClosureBaked(BlockStateModel boxModel, BlockStateModel boxLidModel, BlockStateModel boxLidRotatedModel, boolean isOpen) {
        this.isOpen = isOpen;
        this.boxModel = boxModel;
        this.boxLidModel = boxLidModel;
        this.boxLidRotatedModel = boxLidRotatedModel;
    }

    public BlockStateModel getBoxModel() {
        return this.boxModel;
    }

    public BlockStateModel getBoxLidModel() {
        return this.boxLidModel;
    }

    public List<BakedQuad> getGeneralQuads() {
        LinkedList quads = Lists.newLinkedList();
        for (BlockModelPart blockModelPart : this.boxModel.collectParts(this.level, BlockPos.ZERO, this.blockState, this.rand)) {
            quads.addAll(blockModelPart.getQuads(null));
        }
        if (this.isOpen) {
            for (BlockModelPart blockModelPart : this.boxLidRotatedModel.collectParts(this.level, BlockPos.ZERO, this.blockState, this.rand)) {
                quads.addAll(blockModelPart.getQuads(null));
            }
        } else {
            for (BlockModelPart blockModelPart : this.boxLidModel.collectParts(this.level, BlockPos.ZERO, this.blockState, this.rand)) {
                quads.addAll(blockModelPart.getQuads(null));
            }
        }
        return quads;
    }

    public List<BakedQuad> handleBlockState(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand, ModelData extraData, ChunkSectionLayer renderType) {
        return this.getGeneralQuads();
    }

    public ModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, ModelData tileData) {
        return null;
    }

    public List<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return List.of();
    }

    public List<BakedQuad> handleItemState(@javax.annotation.Nullable ItemStack itemStack, @javax.annotation.Nullable Level world, @javax.annotation.Nullable ItemOwner entity) {
        return new ModelBoxOfEternalClosureBaked(this.boxModel, this.boxLidModel, this.boxLidRotatedModel, BlockBoxOfEternalClosure.getSpiritTypeWithFallbackSpirit(itemStack) == null).getGeneralQuads();
    }

    public TextureAtlasSprite particleIcon() {
        return this.boxModel.particleIcon();
    }

    public boolean usesBlockLight() {
        return false;
    }

    public UnbakedModel wrapped() {
        return null;
    }

    @Nullable
    public ResolvedModel parent() {
        return null;
    }

    public ItemTransforms getTopTransforms() {
        return TRANSFORMS;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public String toString() {
        return "ModelBoxOfEternalClosureBaked(isOpen=" + this.isOpen() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModelBoxOfEternalClosureBaked)) {
            return false;
        }
        ModelBoxOfEternalClosureBaked other = (ModelBoxOfEternalClosureBaked)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return this.isOpen() == other.isOpen();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModelBoxOfEternalClosureBaked;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOpen() ? 79 : 97);
        return result;
    }

    public String debugName() {
        return "evilcraft:box_of_eternal_closure";
    }

    public record Unbaked(Identifier box, Identifier boxLid, Identifier boxLidRotated, Variant.SimpleModelState modelState) implements CustomUnbakedBlockStateModel
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Identifier.CODEC.fieldOf("box").forGetter(Unbaked::box), (App)Identifier.CODEC.fieldOf("box_lid").forGetter(Unbaked::boxLid), (App)Identifier.CODEC.fieldOf("box_lid_rotated").forGetter(Unbaked::boxLidRotated), (App)Variant.SimpleModelState.MAP_CODEC.forGetter(Unbaked::modelState)).apply((Applicative)builder, Unbaked::new));
        public static final Identifier ID = Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"box_of_eternal_closure");

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            resolver.markDependency(this.box);
            resolver.markDependency(this.boxLid);
            resolver.markDependency(this.boxLidRotated);
        }

        public BlockStateModel bake(ModelBaker baker) {
            ModelState modelState = this.modelState.asModelState();
            return new ModelBoxOfEternalClosureBaked(ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (Identifier)this.box, (ModelState)modelState), ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (Identifier)this.boxLid, (ModelState)modelState), ModelHelpers.bakeSingleBlockStateModel((ModelBaker)baker, (Identifier)this.boxLidRotated, (ModelState)modelState), false);
        }

        public MapCodec<? extends CustomUnbakedBlockStateModel> codec() {
            return CODEC;
        }
    }
}

