/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Rarity;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;

public class BroomPartBase
implements IBroomPart {
    private final Identifier id;
    private final IBroomPart.BroomPartType type;
    private final float length;
    private final Rarity rarity;
    private final boolean effect;

    public BroomPartBase(Identifier id, IBroomPart.BroomPartType type, float length) {
        this(id, type, length, Rarity.COMMON, false);
    }

    public BroomPartBase(Identifier id, IBroomPart.BroomPartType type, float length, Rarity rarity, boolean effect) {
        this.id = id;
        this.type = type;
        this.length = length;
        this.rarity = rarity;
        this.effect = effect;
        this.registerModelIdentifier();
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    protected void registerModelIdentifier() {
        BroomParts.REGISTRY.registerPartModel(this, Identifier.fromNamespaceAndPath((String)this.getId().getNamespace(), (String)("broom_part/" + this.getId().getPath().toLowerCase(Locale.ROOT))));
    }

    @Override
    public String getTranslationKey() {
        return "broom.parts." + this.getId().getNamespace() + "." + this.getId().getPath();
    }

    @Override
    @Nullable
    public Component getTooltipLine(String prefix) {
        return Component.literal((String)prefix).append((Component)Component.translatable((String)this.getTranslationKey()));
    }

    @Override
    public boolean shouldAutoRegisterMissingItem() {
        return true;
    }

    @Override
    public int getModelColor() {
        return IModHelpers.get().getBaseHelpers().RGBAToInt(255, 255, 255, 255);
    }

    @Override
    public IBroomPart.BroomPartType getType() {
        return this.type;
    }

    @Override
    public float getLength() {
        return this.length;
    }

    @Override
    public Rarity getRarity() {
        return this.rarity;
    }

    @Override
    public boolean isEffect() {
        return this.effect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BroomPartBase)) {
            return false;
        }
        BroomPartBase other = (BroomPartBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Identifier this$id = this.getId();
        Identifier other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        IBroomPart.BroomPartType this$type = this.getType();
        IBroomPart.BroomPartType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (Float.compare(this.getLength(), other.getLength()) != 0) {
            return false;
        }
        Rarity this$rarity = this.getRarity();
        Rarity other$rarity = other.getRarity();
        if (this$rarity == null ? other$rarity != null : !this$rarity.equals(other$rarity)) {
            return false;
        }
        return this.isEffect() == other.isEffect();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BroomPartBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identifier $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        IBroomPart.BroomPartType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getLength());
        Rarity $rarity = this.getRarity();
        result = result * 59 + ($rarity == null ? 43 : $rarity.hashCode());
        result = result * 59 + (this.isEffect() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "BroomPartBase(id=" + String.valueOf(this.getId()) + ", type=" + String.valueOf(this.getType()) + ", length=" + this.getLength() + ", rarity=" + String.valueOf(this.getRarity()) + ", effect=" + this.isEffect() + ")";
    }
}

