/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.broom;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.api.broom.IBroomPartRegistry;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.broom.BroomPartsContents;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class BroomPartRegistry
implements IBroomPartRegistry {
    private static final String NBT_TAG_NAME = "broom_parts_tag";
    private final Map<Identifier, IBroomPart> parts = Maps.newLinkedHashMap();
    private final Multimap<IBroomPart, Supplier<ItemStack>> partItems = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
    private final Multimap<IBroomPart.BroomPartType, IBroomPart> partsByType = MultimapBuilder.SetMultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<IBroomPart, Map<BroomModifier, Float>> baseModifiers = Maps.newHashMap();
    private Map<IBroomPart, Identifier> partModels;

    public BroomPartRegistry() {
        EvilCraft._instance.getModEventBus().addListener(EventPriority.HIGHEST, this::beforeItemsRegistered);
        NeoForge.EVENT_BUS.addListener(this::onTooltipEvent);
        this.partModels = Maps.newHashMap();
    }

    @Override
    public <P extends IBroomPart> P registerPart(P part) {
        Objects.requireNonNull(part);
        this.parts.put(part.getId(), part);
        this.partsByType.put((Object)part.getType(), part);
        return part;
    }

    @Override
    public <P extends IBroomPart> void registerPartItem(@Nullable P part, Supplier<ItemStack> item) {
        if (part != null) {
            Objects.requireNonNull(item);
            this.partItems.put(part, (Object)Suppliers.memoize(() -> {
                ItemStack itemStack = (ItemStack)item.get();
                itemStack.set(DataComponents.RARITY, (Object)part.getRarity());
                return itemStack;
            }));
        }
    }

    @Override
    public <P extends IBroomPart> void registerBaseModifiers(@Nullable P part, Map<BroomModifier, Float> modifiers) {
        if (part != null) {
            this.baseModifiers.put(part, modifiers);
        }
    }

    @Override
    public <P extends IBroomPart> void registerBaseModifiers(@Nullable P part, BroomModifier modifier, float modifierValue) {
        HashMap map = Maps.newHashMap();
        map.put(modifier, Float.valueOf(modifierValue));
        this.registerBaseModifiers(part, map);
    }

    @Override
    public <P extends IBroomPart> Map<BroomModifier, Float> getBaseModifiersFromPart(P part) {
        if (this.baseModifiers.containsKey(part)) {
            return this.baseModifiers.get(part);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<BroomModifier, Float> getBaseModifiersFromBroom(ItemStack broomStack) {
        HashMap baseModifiers = Maps.newHashMap();
        for (IBroomPart part : this.getBroomParts(broomStack)) {
            for (Map.Entry<BroomModifier, Float> entry : BroomParts.REGISTRY.getBaseModifiersFromPart(part).entrySet()) {
                BroomModifier modifier = entry.getKey();
                if (baseModifiers.containsKey(modifier)) {
                    baseModifiers.put(modifier, Float.valueOf(entry.getValue().floatValue() + ((Float)baseModifiers.get(modifier)).floatValue()));
                    continue;
                }
                baseModifiers.put(modifier, entry.getValue());
            }
        }
        return baseModifiers;
    }

    @Override
    public <P extends IBroomPart> Collection<ItemStack> getItemsFromPart(P part) {
        return this.partItems.get(part).stream().map(Supplier::get).toList();
    }

    @Override
    public <P extends IBroomPart> P getPartFromItem(ItemStack item) {
        for (Map.Entry entry : this.partItems.entries()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)item, (ItemStack)((ItemStack)((Supplier)entry.getValue()).get()))) continue;
            return (P)((IBroomPart)entry.getKey());
        }
        return null;
    }

    @Override
    public Collection<IBroomPart> getParts() {
        return Collections.unmodifiableCollection(this.parts.values());
    }

    @Override
    public IBroomPart getPart(Identifier partId) {
        return this.parts.get(partId);
    }

    @Override
    public Collection<IBroomPart> getParts(IBroomPart.BroomPartType type) {
        return Collections.unmodifiableCollection(this.partsByType.get((Object)type));
    }

    @Override
    public void registerPartModel(IBroomPart part, Identifier modelLocation) {
        this.partModels.put(part, modelLocation);
    }

    @Override
    public Identifier getPartModel(IBroomPart part) {
        return this.partModels.get(part);
    }

    @Override
    public Collection<Identifier> getPartModels() {
        return Collections.unmodifiableCollection(this.partModels.values());
    }

    @Override
    public Collection<IBroomPart> getBroomParts(ItemStack broomStack) {
        if (!broomStack.isEmpty()) {
            ArrayList parts = Lists.newArrayList();
            if (broomStack.has(RegistryEntries.COMPONENT_BROOM_PARTS)) {
                parts.addAll(((BroomPartsContents)broomStack.get(RegistryEntries.COMPONENT_BROOM_PARTS)).getParts());
            }
            if (parts.isEmpty() && BroomParts.BRUSH_WHEAT != null) {
                return Lists.newArrayList((Object[])new IBroomPart[]{BroomParts.BRUSH_WHEAT, BroomParts.CAP_GEM_DARK, BroomParts.ROD_WOOD});
            }
            return parts;
        }
        return Collections.emptyList();
    }

    @Override
    public void setBroomParts(ItemStack broomStack, Collection<IBroomPart> broomParts) {
        broomStack.set(RegistryEntries.COMPONENT_BROOM_PARTS, (Object)new BroomPartsContents(Lists.newArrayList(broomParts)));
        broomStack.set(DataComponents.RARITY, (Object)this.getRarity(broomParts));
    }

    protected Rarity getRarity(Collection<IBroomPart> broomParts) {
        int maxRarity = 0;
        for (IBroomPart part : broomParts) {
            maxRarity = Math.max(maxRarity, part.getRarity().ordinal());
        }
        return Rarity.values()[maxRarity];
    }

    public void onTooltipEvent(ItemTooltipEvent event) {
        Map<BroomModifier, Float> modifiers;
        Object part;
        if (ItemBroomConfig.broomPartTooltips && (part = this.getPartFromItem(event.getItemStack())) != null && !(modifiers = this.getBaseModifiersFromPart(part)).isEmpty()) {
            if (IModHelpers.get().getMinecraftClientHelpers().isShifted()) {
                event.getToolTip().add(Component.translatable((String)"broom.modifiers.evilcraft.types").withStyle(ChatFormatting.ITALIC));
                for (Map.Entry<BroomModifier, Float> entry : modifiers.entrySet()) {
                    event.getToolTip().add(entry.getKey().getTooltipLine("  ", entry.getValue().floatValue(), 0.0f, false));
                }
            } else {
                event.getToolTip().add(Component.translatable((String)"broom.parts.evilcraft.shiftinfo").withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    public void beforeItemsRegistered(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            this.parts.clear();
            this.partItems.clear();
            this.partsByType.clear();
            this.baseModifiers.clear();
            if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
                this.partModels.clear();
            }
        }
    }
}

