/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConverter;

public class ImplicitFluidConversionTank
extends SingleUseTank {
    private ImplicitFluidConverter converter;

    public ImplicitFluidConversionTank(int capacity, ImplicitFluidConverter converter) {
        super(capacity);
        this.converter = converter;
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (!this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack converted = this.converter.convert(resource.toStack(amount));
        if (converted.isEmpty()) {
            return 0;
        }
        double ratio = !resource.isEmpty() ? this.converter.getRatio(resource.getFluid()) : 1.0;
        return (int)Math.ceil((double)super.insert(index, FluidResource.of((FluidStack)converted), converted.getAmount(), transaction) / ratio);
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (!this.canDrainFluidType(resource)) {
            return 0;
        }
        return super.extract(index, (Resource)resource, amount, transaction);
    }

    public boolean canFillFluidType(FluidResource fluid) {
        return fluid.isEmpty() || fluid.getFluid() == this.converter.getTarget() || this.converter.canConvert(fluid.getFluid());
    }

    public boolean canDrainFluidType(FluidResource fluid) {
        return fluid.isEmpty() || fluid.getFluid() == this.converter.getTarget() || this.converter.canConvert(fluid.getFluid());
    }
}

