/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.helper;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.RegistryEntries;

public class ItemHelpers {
    private static final int MB_FILL_PERTICK = GeneralConfig.mbFlowRate;
    public static final String NBT_KEY_ENABLED = "enabled";
    private static ItemStack bloodBucket = null;

    public static boolean isActivated(ItemStack itemStack) {
        return !itemStack.isEmpty() && (Boolean)itemStack.getOrDefault(RegistryEntries.COMPONENT_ACTIVATED, (Object)false) != false;
    }

    public static void toggleActivation(ItemStack itemStack) {
        if (ItemHelpers.isActivated(itemStack)) {
            itemStack.remove(RegistryEntries.COMPONENT_ACTIVATED);
        } else {
            itemStack.set(RegistryEntries.COMPONENT_ACTIVATED, (Object)true);
        }
    }

    public static void updateAutoFill(ResourceHandler<FluidResource> toDrain, ItemStack toDrainItem, Level world, Entity entity, boolean fillBuckets) {
        FluidStack tickFluid;
        if (entity instanceof Player && !world.isClientSide() && !(tickFluid = FluidUtil.getStack(toDrain, (int)0)).isEmpty()) {
            Player player = (Player)entity;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack held = player.getItemInHand(hand);
                if (held.isEmpty() || !fillBuckets && held.getItem() == Items.BUCKET) continue;
                ItemStack toFill = held.split(1);
                ItemStack filled = ItemHelpers.tryFillContainerForPlayer(toDrain, toDrainItem, ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand), toFill, tickFluid, player);
                if (!filled.isEmpty()) {
                    if (player.getItemInHand(hand).isEmpty()) {
                        player.setItemInHand(hand, filled);
                        continue;
                    }
                    player.addItem(filled);
                    continue;
                }
                held.grow(1);
            }
        }
    }

    public static ItemStack tryFillContainerForPlayer(ResourceHandler<FluidResource> toDrain, ItemStack toDrainItem, ItemAccess toFill, ItemStack toFillItem, FluidStack tickFluid, Player player) {
        ResourceHandler toFillHandler;
        int maxFill = MB_FILL_PERTICK;
        if (toFillItem.getItem() == Items.BUCKET) {
            maxFill = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume();
        }
        if ((toFillHandler = (ResourceHandler)toFill.getCapability(Capabilities.Fluid.ITEM)) != null && toFillItem != toDrainItem && player.getUseItemRemainingTicks() == 0) {
            FluidStack moved = IModHelpersNeoForge.get().getFluidHelpers().move(toDrain, toFillHandler, Math.min(maxFill, tickFluid.getAmount()), null, false, false);
            return moved.isEmpty() ? ItemStack.EMPTY : toFill.getResource().toStack(toFill.getAmount());
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getBloodBucket() {
        if (bloodBucket == null) {
            bloodBucket = new ItemStack(RegistryEntries.ITEM_BUCKET_BLOOD);
        }
        return bloodBucket;
    }
}

