/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.recipe.type;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockEnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.recipe.display.RecipeDisplayEnvironmentalAccumulator;
import org.cyclops.evilcraft.core.weather.WeatherType;

public class RecipeEnvironmentalAccumulator
implements Recipe<Inventory> {
    private final Ingredient inputIngredient;
    private final WeatherType inputWeather;
    private final Either<ItemStack, ItemStackFromIngredient> outputItem;
    private final WeatherType outputWeather;
    private final Optional<Integer> duration;
    private final Optional<Integer> cooldownTime;
    private final Optional<Float> processingSpeed;
    private PlacementInfo placementInfo;

    public RecipeEnvironmentalAccumulator(Ingredient inputIngredient, WeatherType inputWeather, Either<ItemStack, ItemStackFromIngredient> outputItem, WeatherType outputWeather, Optional<Integer> duration, Optional<Integer> cooldownTime, Optional<Float> processingSpeed) {
        this.inputIngredient = inputIngredient;
        this.inputWeather = inputWeather;
        this.outputItem = outputItem;
        this.outputWeather = outputWeather;
        this.duration = duration;
        this.cooldownTime = cooldownTime;
        this.processingSpeed = processingSpeed;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public WeatherType getInputWeather() {
        return this.inputWeather;
    }

    public Either<ItemStack, ItemStackFromIngredient> getOutputItem() {
        return this.outputItem;
    }

    public ItemStack getOutputItemFirst() {
        return (ItemStack)this.getOutputItem().map(l -> l, ItemStackFromIngredient::getFirstItemStack);
    }

    public WeatherType getOutputWeather() {
        return this.outputWeather;
    }

    public Optional<Integer> getDurationRaw() {
        return this.duration;
    }

    public Optional<Integer> getCooldownTimeRaw() {
        return this.cooldownTime;
    }

    public Optional<Float> getProcessingSpeedRaw() {
        return this.processingSpeed;
    }

    public int getDuration() {
        int duration = this.getDurationRaw().orElse(-1);
        if (duration < 0) {
            return BlockEnvironmentalAccumulatorConfig.defaultProcessItemTickCount;
        }
        return duration;
    }

    public int getCooldownTime() {
        int cooldownTime = this.getCooldownTimeRaw().orElse(-1);
        if (cooldownTime < 0) {
            return BlockEnvironmentalAccumulatorConfig.defaultTickCooldown;
        }
        return cooldownTime;
    }

    public float getProcessingSpeed() {
        float processingSpeed = this.getProcessingSpeedRaw().orElse(Float.valueOf(-1.0f)).floatValue();
        if (processingSpeed < 0.0f) {
            return (float)BlockEnvironmentalAccumulatorConfig.defaultProcessItemSpeed;
        }
        return processingSpeed;
    }

    public boolean matches(Inventory inv, Level worldIn) {
        return this.inputIngredient.test(inv.getItem(0)) && this.inputWeather.isActive(worldIn);
    }

    public ItemStack assemble(Inventory inv, HolderLookup.Provider registryAccess) {
        ItemStack inputStack = inv.getItem(0);
        ItemStack itemStack = this.getResultItem(registryAccess).copy();
        if (!inputStack.isEmpty()) {
            for (DataComponentType dataComponentType : inputStack.getComponents().keySet()) {
                if (dataComponentType == RegistryEntries.COMPONENT_WEATHER_CONTAINER_TYPE.value()) continue;
                itemStack.set(dataComponentType, inputStack.get(dataComponentType));
            }
        }
        return itemStack;
    }

    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.getOutputItemFirst().copy();
    }

    public RecipeSerializer<? extends Recipe<Inventory>> getSerializer() {
        return (RecipeSerializer)RegistryEntries.RECIPESERIALIZER_ENVIRONMENTAL_ACCUMULATOR.get();
    }

    public RecipeType<? extends Recipe<Inventory>> getType() {
        return (RecipeType)RegistryEntries.RECIPETYPE_ENVIRONMENTAL_ACCUMULATOR.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create((Ingredient)this.inputIngredient);
        }
        return this.placementInfo;
    }

    public RecipeBookCategory recipeBookCategory() {
        return (RecipeBookCategory)RegistryEntries.RECIPEBOOKCATEGORY_ENVIRONMENTAL_ACCUMULATOR.get();
    }

    public List<RecipeDisplay> display() {
        return List.of(new RecipeDisplayEnvironmentalAccumulator(this.getInputIngredient().display(), this.getInputWeather(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.getOutputItemFirst()), this.getOutputWeather(), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(((Block)RegistryEntries.BLOCK_ENVIRONMENTAL_ACCUMULATOR.get()).asItem()), this.getDuration(), this.getCooldownTime(), this.getProcessingSpeed()));
    }

    public static interface Inventory
    extends RecipeInput {
        public Level getWorld();

        public BlockPos getPos();
    }

    public static class InventoryDummy
    implements Inventory {
        private final List<ItemStack> itemStacks;

        public InventoryDummy(ItemStack ... stacksIn) {
            this.itemStacks = Lists.newArrayList((Object[])stacksIn);
        }

        @Override
        public Level getWorld() {
            return null;
        }

        @Override
        public BlockPos getPos() {
            return null;
        }

        public ItemStack getItem(int i) {
            return this.itemStacks.get(i);
        }

        public int size() {
            return this.itemStacks.size();
        }
    }
}

