/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.evilcraft.RegistryEntries;

public class EntityLightningGrenade
extends ThrowableProjectile
implements ItemSupplier {
    public EntityLightningGrenade(Level world, LivingEntity entity) {
        super((EntityType)RegistryEntries.ENTITY_LIGHTNING_GRENADE.get(), entity.getX(), entity.getY(), entity.getZ(), world);
    }

    public EntityLightningGrenade(EntityType<? extends EntityLightningGrenade> type, Level world) {
        super(type, world);
    }

    protected void onHit(HitResult par1MovingObjectPosition) {
        if (par1MovingObjectPosition.getType() == HitResult.Type.ENTITY) {
            ((EntityHitResult)par1MovingObjectPosition).getEntity().hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), 0.0f);
        }
        if (!this.level().isClientSide()) {
            if (this.getOwner() != null && this.getOwner() instanceof ServerPlayer) {
                BlockPos pos = BlockPos.containing((Position)par1MovingObjectPosition.getLocation());
                EntityHelpers.onEntityCollided((Level)this.level(), (BlockPos)pos, (BlockState)this.level().getBlockState(pos), (Entity)this);
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.level(), EntitySpawnReason.SPAWN_ITEM_USE);
                bolt.snapTo(this.getX(), this.getY(), this.getZ());
                this.level().addFreshEntity((Entity)bolt);
            }
            this.remove(Entity.RemovalReason.DISCARDED);
        } else {
            for (int i = 0; i < 32; ++i) {
                Minecraft.getInstance().level.addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public ItemStack getItem() {
        return new ItemStack(RegistryEntries.ITEM_LIGHTNING_GRENADE);
    }
}

