/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.extendedconfig.EntityClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.EntityConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.entity.monster.EntityPoisonousLibelle;
import org.cyclops.evilcraft.entity.monster.EntityPoisonousLibelleConfigClient;

public class EntityPoisonousLibelleConfig
extends EntityConfigCommon<ModBaseNeoForge<?>, EntityPoisonousLibelle> {
    @ConfigurablePropertyCommon(category="mob", comment="Should the Poisonous Libelle do damage, next to poisoning?", isCommandable=true)
    public static boolean hasAttackDamage = false;
    @ConfigurablePropertyCommon(category="mob", comment="The minimum Y-level this mob can spawn at.", isCommandable=true)
    public static int minY = 55;
    @ConfigurablePropertyCommon(category="mob", comment="1/X chance on getting poisoned when hit.", isCommandable=true)
    public static int poisonChance = 20;

    public EntityPoisonousLibelleConfig() {
        super((IModBase)EvilCraft._instance, "poisonous_libelle", eConfig -> EntityType.Builder.of(EntityPoisonousLibelle::new, (MobCategory)MobCategory.MONSTER).sized(0.5f, 0.45f).fireImmune(), EntityPoisonousLibelleConfig.getDefaultSpawnEggItemConfigConstructor((IModBase)EvilCraft._instance, (String)"poisonous_libelle_spawn_egg"));
        EvilCraft._instance.getModEventBus().addListener(this::onEntityAttributeCreationEvent);
        EvilCraft._instance.getModEventBus().addListener(this::registerSpawnPlacements);
    }

    public EntityClientConfig<ModBaseNeoForge<?>, EntityPoisonousLibelle> constructEntityClientConfig() {
        return new EntityPoisonousLibelleConfigClient(this);
    }

    public void onEntityAttributeCreationEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)this.getInstance(), Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.625).build());
    }

    public void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)this.getInstance(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EntityPoisonousLibelle::checkAnyLightMonsterSpawnRules, RegisterSpawnPlacementsEvent.Operation.AND);
    }
}

