/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.monster;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EntityType;
import org.apache.commons.lang3.StringUtils;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpiritData;

public class EntityVengeanceSpiritSyncedData
extends EntityVengeanceSpiritData {
    private final Supplier<SynchedEntityData> dataManager;

    public EntityVengeanceSpiritSyncedData(SynchedEntityData.Builder builder, Supplier<SynchedEntityData> dataManager) {
        this.register(builder);
        this.dataManager = dataManager;
    }

    public EntityVengeanceSpiritSyncedData(SynchedEntityData.Builder builder, Supplier<SynchedEntityData> dataManager, EntityType<?> innerEntity) {
        super(innerEntity);
        this.register(builder);
        this.dataManager = dataManager;
    }

    public void register(SynchedEntityData.Builder builder) {
        EntityType<?> innerEntity = super.getInnerEntityType();
        builder.define(EntityVengeanceSpirit.WATCHERID_INNER, (Object)(innerEntity == null ? "" : BuiltInRegistries.ENTITY_TYPE.getKey(innerEntity).toString()));
        builder.define(EntityVengeanceSpirit.WATCHERID_REMAININGLIFE, (Object)super.getRemainingLife());
        builder.define(EntityVengeanceSpirit.WATCHERID_FROZENDURATION, (Object)super.getFrozenDuration());
        builder.define(EntityVengeanceSpirit.WATCHERID_GLOBALVENGEANCE, (Object)0);
        builder.define(EntityVengeanceSpirit.WATCHERID_VENGEANCEPLAYERS, (Object)"");
        builder.define(EntityVengeanceSpirit.WATCHERID_ISSWARM, (Object)(super.isSwarm() ? 1 : 0));
        builder.define(EntityVengeanceSpirit.WATCHERID_SWARMTIER, (Object)super.getSwarmTier());
        builder.define(EntityVengeanceSpirit.WATCHERID_BUILDUP, (Object)super.getBuildupDuration());
        builder.define(EntityVengeanceSpirit.WATCHERID_PLAYERID, (Object)super.getPlayerId());
        builder.define(EntityVengeanceSpirit.WATCHERID_PLAYERNAME, (Object)super.getPlayerName());
    }

    @Override
    @Nullable
    public EntityType<?> getInnerEntityType() {
        String entityName = (String)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_INNER);
        return entityName.isEmpty() ? null : (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(Identifier.parse((String)entityName));
    }

    @Override
    public void setInnerEntityType(EntityType<?> innerEntityType) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_INNER, (Object)(innerEntityType == null ? "" : BuiltInRegistries.ENTITY_TYPE.getKey(innerEntityType).toString()));
    }

    @Override
    public int getRemainingLife() {
        return (Integer)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_REMAININGLIFE);
    }

    @Override
    public void setRemainingLife(int remainingLife) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_REMAININGLIFE, (Object)remainingLife);
    }

    @Override
    public int getFrozenDuration() {
        return (Integer)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_FROZENDURATION);
    }

    @Override
    public void setFrozenDuration(int frozenDuration) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_FROZENDURATION, (Object)frozenDuration);
    }

    @Override
    public String getPlayerId() {
        return (String)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_PLAYERID);
    }

    @Override
    public void setPlayerId(String playerId) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_PLAYERID, (Object)playerId);
    }

    @Override
    public String getPlayerName() {
        return (String)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_PLAYERNAME);
    }

    @Override
    public void setPlayerName(String playerName) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_PLAYERNAME, (Object)playerName);
    }

    @Override
    public boolean isSwarm() {
        return (Integer)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_ISSWARM) == 1;
    }

    @Override
    public void setSwarm(boolean isSwarm) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_ISSWARM, (Object)(isSwarm ? 1 : 0));
    }

    @Override
    public int getSwarmTier() {
        return (Integer)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_SWARMTIER);
    }

    @Override
    public void setSwarmTier(int swarmTier) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_SWARMTIER, (Object)swarmTier);
    }

    public boolean isGlobalVengeance() {
        return (Integer)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_GLOBALVENGEANCE) == 1;
    }

    public void setGlobalVengeance(boolean globalVengeance) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_GLOBALVENGEANCE, (Object)(globalVengeance ? 1 : 0));
    }

    public String[] getVengeancePlayers() {
        String encodedPlayers = (String)this.dataManager.get().get(EntityVengeanceSpirit.WATCHERID_VENGEANCEPLAYERS);
        if (encodedPlayers.length() == 0) {
            return new String[0];
        }
        return encodedPlayers.split("&");
    }

    public void setVengeancePlayers(String[] vengeancePlayers) {
        this.dataManager.get().set(EntityVengeanceSpirit.WATCHERID_VENGEANCEPLAYERS, (Object)StringUtils.join((Object[])vengeancePlayers, (String)"&"));
    }
}

