/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.villager.Villager;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.monster.EntityWerewolf;
import org.cyclops.evilcraft.entity.villager.VillagerProfessionWerewolfConfig;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class EntityStruckByLightningEventHook {
    private LightningBolt lastLightningBolt;
    private Set<Integer> affectedVillagers;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEntityStruckByLightning(EntityStruckByLightningEvent event) {
        this.empowerItem(event);
        this.transformVillager(event);
    }

    private void empowerItem(EntityStruckByLightningEvent event) {
        IItemEmpowerable empowerable;
        ItemEntity entity;
        if (event.getEntity() instanceof ItemEntity && (entity = (ItemEntity)event.getEntity()).getItem().getItem() instanceof IItemEmpowerable && !(empowerable = (IItemEmpowerable)entity.getItem().getItem()).isEmpowered(entity.getItem())) {
            entity.setItem(empowerable.empower(entity.getItem()));
            event.setCanceled(true);
            event.getLightning().remove(Entity.RemovalReason.DISCARDED);
        }
    }

    private void transformVillager(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof Villager && VillagerProfessionWerewolfConfig.convertOnLightning) {
            Villager entity = (Villager)event.getEntity();
            if (this.lastLightningBolt != event.getLightning()) {
                this.lastLightningBolt = event.getLightning();
                this.affectedVillagers = new HashSet<Integer>();
            }
            if (!this.affectedVillagers.add(entity.getId())) {
                event.setCanceled(true);
                return;
            }
            if (entity.level().random.nextBoolean()) {
                event.setCanceled(false);
                return;
            }
            if (entity.getVillagerData().profession().is(RegistryEntries.VILLAGER_PROFESSION_WEREWOLF.getKey())) {
                event.setCanceled(true);
                EntityWerewolf.initializeWerewolfVillagerData(entity);
            }
        }
    }
}

