/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.event;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.evilcraft.GeneralConfig;
import org.cyclops.evilcraft.core.algorithm.Wrapper;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.entity.item.EntityBroom;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class RenderOverlayEventHook {
    private static final int WIDTH = 5;
    private static final int HEIGHT = 51;
    protected static final Identifier BROOM_OVERLAY = Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/overlay.png");
    protected static final Identifier BLOOD_OVERLAY = Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"textures/gui/overlay.png");
    private int filledHeight = -1;

    @SubscribeEvent
    public void onRenderOverlayEvent(RenderGuiEvent.Post event) {
        this.renderBroomOverlay(event);
        this.renderBloodOverlay(event);
    }

    public void renderBroomOverlay(RenderGuiEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getVehicle() instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)player.getVehicle();
            ItemStack broomStack = broom.getBroomStack();
            Window resolution = Minecraft.getInstance().getWindow();
            int height = 21;
            int width = 21;
            OverlayPosition overlayPosition = OverlayPosition.values()[Mth.clamp((int)ItemBroomConfig.guiOverlayPosition, (int)0, (int)(OverlayPosition.values().length - 1))];
            int x = overlayPosition.getX(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetX;
            int y = overlayPosition.getY(resolution, width, height) + ItemBroomConfig.guiOverlayPositionOffsetY;
            event.getGuiGraphics().blit(RenderPipelines.GUI_TEXTURED, BROOM_OVERLAY, x, y, 11.0f, 0.0f, 24, 24, 256, 256);
            event.getGuiGraphics().renderItem(broomStack, x + 3, y + 3);
            event.getGuiGraphics().renderItemDecorations(Minecraft.getInstance().gui.getFont(), broomStack, x + 3, y + 3, "");
        }
    }

    public void renderBloodOverlay(RenderGuiEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (GeneralConfig.bloodGuiOverlay) {
            if (this.filledHeight < 0 || IModHelpers.get().getWorldHelpers().efficientTick(player.level(), 50, new int[0])) {
                Wrapper<Integer> amount = new Wrapper<Integer>(0);
                Wrapper<Long> capacity = new Wrapper<Long>(1L);
                PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator((Player)player);
                while (it.hasNext()) {
                    ResourceHandler fluidHandler;
                    ItemStack itemStack = it.next();
                    if (itemStack.isEmpty() || (fluidHandler = (ResourceHandler)itemStack.getCapability(Capabilities.Fluid.ITEM, (Object)ItemAccess.forStack((ItemStack)itemStack))) == null) continue;
                    FluidStack fluidStack = IModHelpersNeoForge.get().getFluidHelpers().getFluid(fluidHandler);
                    if (!fluidStack.isEmpty() && BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) {
                        amount.set(amount.get() + fluidStack.getAmount());
                    }
                    if (!fluidStack.isEmpty() && !BloodFluidConverter.getInstance().canConvert(fluidStack.getFluid())) continue;
                    capacity.set(capacity.get() + IModHelpersNeoForge.get().getFluidHelpers().getCapacity(fluidHandler));
                }
                this.filledHeight = (int)Math.floor(51.0f * ((float)amount.get().intValue() / (float)capacity.get().longValue()));
            }
            if (this.filledHeight > 0) {
                OverlayPosition overlayPosition = OverlayPosition.values()[Mth.clamp((int)GeneralConfig.bloodGuiOverlayPosition, (int)0, (int)(OverlayPosition.values().length - 1))];
                Window resolution = Minecraft.getInstance().getWindow();
                int x = overlayPosition.getX(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetX;
                int y = overlayPosition.getY(resolution, 5, 51) + GeneralConfig.bloodGuiOverlayPositionOffsetY;
                event.getGuiGraphics().blit(RenderPipelines.GUI_TEXTURED, BLOOD_OVERLAY, x, y, 0.0f, 0.0f, 5, 51, 256, 256);
                event.getGuiGraphics().blit(RenderPipelines.GUI_TEXTURED, BLOOD_OVERLAY, x, y + (51 - this.filledHeight), 5.0f, (float)(51 - this.filledHeight), 5, this.filledHeight, 256, 256);
            }
        }
    }

    public static enum OverlayPosition {
        NE{

            @Override
            public int getX(Window resolution, int width, int height) {
                return resolution.getGuiScaledWidth() - width;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return 0;
            }
        }
        ,
        SE{

            @Override
            public int getX(Window resolution, int width, int height) {
                return resolution.getGuiScaledWidth() - width;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return resolution.getGuiScaledHeight() - height;
            }
        }
        ,
        SW{

            @Override
            public int getX(Window resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return resolution.getGuiScaledHeight() - height;
            }
        }
        ,
        NW{

            @Override
            public int getX(Window resolution, int width, int height) {
                return 0;
            }

            @Override
            public int getY(Window resolution, int width, int height) {
                return 0;
            }
        };


        public abstract int getX(Window var1, int var2, int var3);

        public abstract int getY(Window var1, int var2, int var3);
    }
}

