/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockBoxOfEternalClosure;
import org.cyclops.evilcraft.blockentity.BlockEntityBoxOfEternalClosure;

public class ItemBlockBoxOfEternalClosure
extends ItemBlockNBT {
    public ItemBlockBoxOfEternalClosure(Block block, Item.Properties builder) {
        super(block, builder);
    }

    protected boolean itemStackDataToTile(ItemStack itemStack, BlockEntity tile) {
        if (tile instanceof BlockEntityBoxOfEternalClosure) {
            ((BlockEntityBoxOfEternalClosure)tile).setSpiritTag((CompoundTag)itemStack.getOrDefault(RegistryEntries.COMPONENT_BOX_SPIRIT_DATA, (Object)new CompoundTag()));
            ((BlockEntityBoxOfEternalClosure)tile).setPlayerId((String)itemStack.getOrDefault(RegistryEntries.COMPONENT_BOX_PLAYER_ID, (Object)""));
            ((BlockEntityBoxOfEternalClosure)tile).setPlayerName((String)itemStack.getOrDefault(RegistryEntries.COMPONENT_BOX_PLAYER_NAME, (Object)""));
            ((BlockEntityBoxOfEternalClosure)tile).initializeState();
        }
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flagIn) {
        tooltipAdder.accept(this.getInfo(stack));
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flagIn);
    }

    public Component getInfo(ItemStack itemStack) {
        MutableComponent content = Component.translatable((String)"general.evilcraft.info.empty").withStyle(ChatFormatting.ITALIC);
        if (BlockBoxOfEternalClosure.hasPlayer(itemStack)) {
            content = Component.literal((String)BlockBoxOfEternalClosure.getPlayerName(itemStack));
        } else {
            EntityType<?> spiritType = BlockBoxOfEternalClosure.getSpiritTypeWithFallbackSpirit(itemStack);
            if (spiritType != null) {
                content = spiritType.getDescription();
            }
        }
        return Component.translatable((String)(this.getDescriptionId() + ".info.content")).withStyle(ChatFormatting.LIGHT_PURPLE).append((Component)content);
    }
}

