/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.item.ItemBloodContainer;
import org.cyclops.evilcraft.entity.item.EntityBroom;

public class ItemBroom
extends ItemBloodContainer
implements IBroom {
    private static final float Y_SPAWN_OFFSET = 1.5f;

    public ItemBroom(Item.Properties properties) {
        super(properties, 10 * IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume());
        if (IModHelpers.get().getMinecraftHelpers().isClientSide()) {
            NeoForge.EVENT_BUS.addListener(this::onFovEvent);
        }
    }

    @Override
    public boolean isPlaceFluids() {
        return false;
    }

    @Override
    public boolean isPickupFluids() {
        return false;
    }

    @Override
    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide() && player.getVehicle() == null && !player.isCrouching()) {
            player.setPos(player.getX(), player.getY() + 1.5, player.getZ());
            EntityBroom entityBroom = new EntityBroom(world, player.getX(), player.getY(), player.getZ());
            entityBroom.setBroomStack(stack);
            entityBroom.setYRot(player.getYRot());
            world.addFreshEntity((Entity)entityBroom);
            player.startRiding((Entity)entityBroom);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(stack);
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (!context.getLevel().isClientSide() && context.getPlayer().isCrouching()) {
            BlockPos blockPos = context.getClickedPos();
            if (!IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)context.getLevel(), blockPos, (Object)context.getClickedFace(), Capabilities.Fluid.BLOCK).isPresent() && context.getLevel().isEmptyBlock(blockPos.offset(0, 1, 0))) {
                EntityBroom entityBroom = new EntityBroom(context.getLevel(), (double)blockPos.getX() + 0.5, (float)blockPos.getY() + 1.5f, (double)blockPos.getZ() + 0.5);
                entityBroom.setBroomStack(stack);
                entityBroom.setYRot(context.getPlayer().getYRot());
                context.getLevel().addFreshEntity((Entity)entityBroom);
                if (!context.getPlayer().isCreative()) {
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public Collection<IBroomPart> getBroomParts(ItemStack itemStack) {
        return BroomParts.REGISTRY.getBroomParts(itemStack);
    }

    @Override
    public Map<BroomModifier, Float> getBroomModifiers(ItemStack itemStack) {
        return BroomModifiers.REGISTRY.getModifiers(itemStack);
    }

    @Override
    public boolean canConsumeBroomEnergy(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return this.canConsume(amount, itemStack, entityLiving instanceof Player ? (Player)entityLiving : null);
    }

    @Override
    public int consumeBroom(int amount, ItemStack itemStack, @Nullable LivingEntity entityLiving) {
        return IModHelpersNeoForge.get().getFluidHelpers().getAmount(this.consume(amount, itemStack, entityLiving instanceof Player ? (Player)entityLiving : null));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemStack, context, tooltipDisplay, list, flag);
        if (IModHelpers.get().getMinecraftClientHelpers().isShifted()) {
            list.accept((Component)Component.translatable((String)"broom.parts.evilcraft.types").withStyle(ChatFormatting.ITALIC));
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(itemStack);
            Map<BroomModifier, Float> modifiers = this.getBroomModifiers(itemStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(baseModifiers.keySet());
            modifierTypes.addAll(modifiers.keySet());
            for (IBroomPart part : this.getBroomParts(itemStack)) {
                Component line = part.getTooltipLine("  ");
                if (line == null) continue;
                list.accept(line);
            }
            Pair<Integer, Integer> modifiersAndMax = this.getModifiersAndMax(modifiers, baseModifiers);
            int modifierCount = (Integer)modifiersAndMax.getLeft();
            int maxModifiers = (Integer)modifiersAndMax.getRight();
            list.accept((Component)Component.translatable((String)"broom.modifiers.evilcraft.types.nameparam", (Object[])new Object[]{modifierCount, maxModifiers}).withStyle(ChatFormatting.ITALIC));
            for (BroomModifier modifier : modifierTypes) {
                if (!modifier.showTooltip()) continue;
                Float value = modifiers.get(modifier);
                Float baseValue = baseModifiers.get(modifier);
                list.accept(modifier.getTooltipLine("  ", value == null ? 0.0f : value.floatValue(), baseValue == null ? 0.0f : baseValue.floatValue()));
            }
        } else {
            list.accept((Component)Component.translatable((String)"broom.evilcraft.shiftinfo").withStyle(ChatFormatting.ITALIC));
        }
    }

    private Pair<Integer, Integer> getModifiersAndMax(Map<BroomModifier, Float> broomModifiers, Map<BroomModifier, Float> baseModifiers) {
        int baseMaxModifiers = 0;
        if (baseModifiers.containsKey(BroomModifiers.MODIFIER_COUNT)) {
            baseMaxModifiers = (int)baseModifiers.get(BroomModifiers.MODIFIER_COUNT).floatValue();
        }
        int maxModifiers = baseMaxModifiers;
        int modifiers = 0;
        for (Map.Entry<BroomModifier, Float> entry : broomModifiers.entrySet()) {
            int tier = BroomModifier.getTier(entry.getKey(), entry.getValue().floatValue());
            if (entry.getKey() == BroomModifiers.MODIFIER_COUNT) {
                maxModifiers += (int)entry.getValue().floatValue();
                continue;
            }
            modifiers += tier;
        }
        return Pair.of((Object)modifiers, (Object)maxModifiers);
    }

    public void onFovEvent(ComputeFovModifierEvent event) {
        if (event.getPlayer().getVehicle() instanceof EntityBroom) {
            EntityBroom broom = (EntityBroom)event.getPlayer().getVehicle();
            double speed = broom.getLastPlayerSpeed();
            event.setNewFovModifier((float)((double)event.getNewFovModifier() + speed / 10.0));
        }
    }
}

