/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.NBTSimpleInventoryItemHeld;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.entity.item.EntityItemEmpowerable;
import org.cyclops.evilcraft.inventory.container.ContainerExaltedCrafter;
import org.cyclops.evilcraft.item.IItemEmpowerable;

public class ItemExaltedCrafter
extends ItemGui
implements IItemEmpowerable {
    private final boolean wooden;
    private final boolean empowered;

    public ItemExaltedCrafter(Item.Properties properties, boolean wooden, boolean empowered) {
        super(properties);
        this.wooden = wooden;
        this.empowered = empowered;
    }

    public boolean isFoil(ItemStack itemStack) {
        return this.isEmpowered(itemStack);
    }

    @Override
    public boolean isEmpowered(ItemStack itemStack) {
        return this.empowered;
    }

    @Override
    public ItemStack empower(ItemStack itemStack) {
        ItemStack newStack = new ItemStack(this.wooden ? RegistryEntries.ITEM_EXALTED_CRAFTER_WOODEN_EMPOWERED : RegistryEntries.ITEM_EXALTED_CRAFTER_EMPOWERED);
        for (DataComponentType componentType : itemStack.getComponents().keySet()) {
            newStack.set(componentType, itemStack.get(componentType));
        }
        return newStack;
    }

    public Container getSupplementaryInventory(Player player, ItemLocation itemLocation) {
        if (this.wooden) {
            return new NBTSimpleInventoryItemHeld(player, itemLocation, 27, 64, "default");
        }
        return player.getEnderChestInventory();
    }

    public boolean hasCustomEntity(ItemStack itemStack) {
        return true;
    }

    public Entity createEntity(Level world, Entity location, ItemStack itemStack) {
        return new EntityItemEmpowerable(world, (ItemEntity)location);
    }

    public static void setReturnToInner(ItemStack itemStack, boolean returnToInner) {
        itemStack.set(RegistryEntries.COMPONENT_EXALTED_CRAFTER_RETURN_TO_INNER, (Object)returnToInner);
    }

    public static boolean isReturnToInner(ItemStack itemStack) {
        return (Boolean)itemStack.getOrDefault(RegistryEntries.COMPONENT_EXALTED_CRAFTER_RETURN_TO_INNER, (Object)false);
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, ItemLocation itemLocation) {
        return new NamedContainerProviderItem(itemLocation, itemLocation.getItemStack(playerEntity).getHoverName(), ContainerExaltedCrafter::new);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerExaltedCrafter.class;
    }

    public InteractionResult use(Level world, Player player, InteractionHand hand) {
        if (world.isClientSide()) {
            world.playSound((Entity)player, player.getX(), player.getY(), player.getZ(), this.wooden ? SoundEvents.CHEST_OPEN : SoundEvents.ENDER_CHEST_OPEN, SoundSource.BLOCKS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        }
        return super.use(world, player, hand);
    }
}

