/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.item;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.ExtendedDamageSources;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.advancement.criterion.DistortTrigger;
import org.cyclops.evilcraft.entity.monster.EntityVengeanceSpirit;
import org.cyclops.evilcraft.item.ItemMace;

public class ItemMaceOfDistortion
extends ItemMace {
    public static final int AOE_TICK_UPDATE = 20;
    private static final int MAXIMUM_CHARGE = 100;
    private static final float MELEE_DAMAGE = 7.0f;
    private static final float RADIAL_DAMAGE = 3.0f;
    private static final int CONTAINER_SIZE = IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() * 4;
    private static final int HIT_USAGE = 5;
    private static final int POWER_LEVELS = 5;

    public ItemMaceOfDistortion(Item.Properties properties) {
        super(properties, CONTAINER_SIZE, 5, 100, 5, 7.0f);
    }

    protected void distortEntities(Level world, LivingEntity initiator, int itemUsedCount, int power) {
        double x = initiator.getX();
        double y = initiator.getY();
        double z = initiator.getZ();
        double area = this.getArea(itemUsedCount);
        AABB box = new AABB(x, y, z, x, y, z).inflate(area);
        List entities = world.getEntities((Entity)initiator, box);
        boolean onePlayer = false;
        for (Entity entity : entities) {
            if (entity instanceof Player) {
                onePlayer = true;
            }
            this.distortEntity(world, initiator, entity, x, y, z, itemUsedCount, power);
        }
        if (initiator instanceof ServerPlayer) {
            ((DistortTrigger)((Object)RegistryEntries.TRIGGER_DISTORT.get())).test((ServerPlayer)initiator, entities);
        }
    }

    public void distortEntity(Level world, @Nullable LivingEntity initiator, Entity entity, double x, double y, double z, int itemUsedCount, int power) {
        double dz;
        double dy;
        double inverseStrength = initiator != null ? (double)(entity.distanceTo((Entity)initiator) / (float)(itemUsedCount + 1)) : 0.1;
        double knock = (double)(power + itemUsedCount / 200) + 1.0;
        double dx = entity.getX() - x;
        double d = Mth.sqrt((float)((float)(dx * dx + (dy = entity.getY() + (double)entity.getEyeHeight() - y) * dy + (dz = entity.getZ() - z) * dz)));
        if (d != 0.0) {
            dx /= d;
            dy /= d;
            dz /= d;
            double strength = (1.0 - inverseStrength) * knock;
            if (entity instanceof LivingEntity) {
                DamageSource damageSource = initiator == null ? ExtendedDamageSources.distorted(world) : (initiator instanceof Player ? initiator.damageSources().playerAttack((Player)initiator) : initiator.damageSources().mobAttack(initiator));
                entity.hurt(damageSource, 3.0f * (float)power);
                if (world.isClientSide()) {
                    ItemMaceOfDistortion.showEntityDistored(world, initiator, entity, power);
                }
            }
            if (entity instanceof EntityVengeanceSpirit) {
                ((EntityVengeanceSpirit)entity).setSwarm(true);
            }
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(strength /= 2.0, strength, strength));
        }
    }

    public static void showEntityDistored(Level world, LivingEntity initiator, Entity entity, int power) {
        world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
        if (initiator != null) {
            world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, (float)(power + 1) / 5.0f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
        }
        world.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, entity.getX(), entity.getY() + (double)world.random.nextFloat(), entity.getZ(), 1.0, 0.0, 0.0);
    }

    @Override
    protected void animateOutOfEnergy(Level world, LivingEntity player) {
        double xCoord = player.getX();
        double yCoord = player.getY();
        double zCoord = player.getZ();
        float particleMotionX = world.random.nextFloat() * 0.2f - 0.1f;
        float particleMotionY = 0.2f;
        float particleMotionZ = world.random.nextFloat() * 0.2f - 0.1f;
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, xCoord, yCoord, zCoord, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        world.playSound((Entity)player, xCoord, yCoord, zCoord, (SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), SoundSource.RECORDS, 0.5f, 0.4f / (world.random.nextFloat() * 0.4f + 0.8f));
    }

    @Override
    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack itemStack) {
        return new ItemAttributeModifiers((List)Lists.newArrayList((Object[])new ItemAttributeModifiers.Entry[]{new ItemAttributeModifiers.Entry(Attributes.ATTACK_DAMAGE, new AttributeModifier(Identifier.fromNamespaceAndPath((String)"evilcraft", (String)"add_mace_damage"), 7.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND)}));
    }

    @Override
    protected void use(Level world, LivingEntity entity, int itemUsedCount, int power) {
        this.distortEntities(world, entity, itemUsedCount, power);
    }
}

