/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.loot.modifier;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.jetbrains.annotations.NotNull;

public class LootModifierInjectBroom
extends LootModifier {
    public static final Supplier<MapCodec<LootModifierInjectBroom>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> LootModifierInjectBroom.codecStart((RecordCodecBuilder.Instance)inst).and((App)Codec.list((Codec)Codec.STRING).fieldOf("loot_tables").forGetter(LootModifierInjectBroom::getLootTables)).apply((Applicative)inst, LootModifierInjectBroom::new)));
    private final List<String> lootTables;

    public LootModifierInjectBroom(LootItemCondition[] conditionsIn, List<String> lootTables) {
        super(conditionsIn);
        this.lootTables = lootTables;
    }

    public List<String> getLootTables() {
        return this.lootTables;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.getLootTables().contains(context.getQueriedLootTableId().toString())) {
            ItemAccess itemAccess = ItemAccess.forStack((ItemStack)new ItemStack(RegistryEntries.ITEM_BROOM));
            IFluidHandlerCapacity fluidHanderFull = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(itemAccess).orElse(null);
            try (Transaction tx = Transaction.openRoot();){
                fluidHanderFull.insert((Resource)FluidResource.of(RegistryEntries.FLUID_BLOOD), fluidHanderFull.getTankCapacity(0) / 2 + context.getRandom().nextInt(fluidHanderFull.getTankCapacity(0) / 2), (TransactionContext)tx);
                tx.commit();
            }
            ItemStack stack = itemAccess.getResource().toStack(itemAccess.getAmount());
            ArrayList parts = Lists.newArrayList(BroomParts.REGISTRY.getParts());
            IBroomPart partRod = this.getRandomPart("rod", parts);
            IBroomPart partBrush = this.getRandomPart("brush", parts);
            IBroomPart partCap = this.getRandomPart("cap", parts);
            BroomParts.REGISTRY.setBroomParts(stack, Lists.newArrayList((Object[])new IBroomPart[]{partRod, partBrush, partCap}));
            ArrayList modifiers = Lists.newArrayList(BroomModifiers.REGISTRY.getModifiers());
            BroomModifier modifier1 = (BroomModifier)modifiers.get(context.getRandom().nextInt(modifiers.size()));
            BroomModifier modifier2 = (BroomModifier)modifiers.get(context.getRandom().nextInt(modifiers.size()));
            HashMap modifiersMap = Maps.newHashMap();
            modifiersMap.put(modifier1, Float.valueOf(modifier1.getTierValue()));
            modifiersMap.put(modifier2, Float.valueOf(modifier2.getTierValue()));
            BroomModifiers.REGISTRY.setModifiers(stack, modifiersMap);
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    private IBroomPart getRandomPart(String type, List<IBroomPart> parts) {
        Random random = new Random();
        IBroomPart part = null;
        while (part == null) {
            part = parts.get(random.nextInt(parts.size()));
            if (part.getId().getPath().startsWith(type)) continue;
            part = null;
        }
        return part;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

