/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.GeneralConfig;
import org.cyclops.cyclopscore.advancement.criterion.GuiContainerOpenTriggerConfig;
import org.cyclops.cyclopscore.advancement.criterion.GuiContainerOpenTriggerEventHooksNeoForge;
import org.cyclops.cyclopscore.advancement.criterion.ItemCraftedTriggerConfig;
import org.cyclops.cyclopscore.advancement.criterion.ItemCraftedTriggerTriggerEventHooksNeoForge;
import org.cyclops.cyclopscore.advancement.criterion.ModItemObtainedTriggerConfig;
import org.cyclops.cyclopscore.advancement.criterion.ModItemObtainedTriggerEventHooksNeoForge;
import org.cyclops.cyclopscore.client.particle.ParticleBlurConfig;
import org.cyclops.cyclopscore.client.particle.ParticleDropColoredConfig;
import org.cyclops.cyclopscore.command.CommandDebug;
import org.cyclops.cyclopscore.command.CommandDumpRegistries;
import org.cyclops.cyclopscore.command.CommandIgnite;
import org.cyclops.cyclopscore.command.CommandInfoBookTest;
import org.cyclops.cyclopscore.command.CommandReloadResources;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeConfigPropertyConfig;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeDebugPacketConfig;
import org.cyclops.cyclopscore.command.argument.ArgumentTypeEnumConfig;
import org.cyclops.cyclopscore.component.DataComponentCapacityConfig;
import org.cyclops.cyclopscore.component.DataComponentEnergyStorageConfig;
import org.cyclops.cyclopscore.component.DataComponentFluidContentConfig;
import org.cyclops.cyclopscore.component.DataComponentInventoryConfig;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.gametest.MethodGameTestInstanceConfig;
import org.cyclops.cyclopscore.gametest.StartupTestNeoForge;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.infobook.InfoBookRegistry;
import org.cyclops.cyclopscore.infobook.test.ContainerInfoBookTestConfig;
import org.cyclops.cyclopscore.infobook.test.InfoBookTest;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.inventory.IRegistryInventoryLocation;
import org.cyclops.cyclopscore.inventory.RegistryInventoryLocation;
import org.cyclops.cyclopscore.loot.modifier.LootModifierInjectItemConfigNeoForge;
import org.cyclops.cyclopscore.metadata.IRegistryExportableRegistry;
import org.cyclops.cyclopscore.metadata.RegistryExportableRegistry;
import org.cyclops.cyclopscore.metadata.RegistryExportables;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.curios.ModCompatCurios;
import org.cyclops.cyclopscore.network.PacketCodecsNeoForge;
import org.cyclops.cyclopscore.persist.nbt.NBTClassTypesNeoForge;
import org.cyclops.cyclopscore.proxy.ClientProxyNeoForge;
import org.cyclops.cyclopscore.proxy.CommonProxyNeoForge;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.cyclopscore.tracking.ImportantUsers;

@Mod(value="cyclopscore")
public class CyclopsCoreNeoForge
extends ModBaseNeoForge<CyclopsCoreNeoForge> {
    public static CyclopsCoreNeoForge _instance;
    private boolean loaded = false;

    public CyclopsCoreNeoForge(IEventBus modEventBus) {
        super("cyclopscore", instance -> {
            _instance = instance;
            CyclopsCoreInstance.MOD = instance;
        }, modEventBus);
        modEventBus.addListener(this::loadComplete);
        this.getRegistryManager().addRegistry(IRegistryExportableRegistry.class, RegistryExportableRegistry.getInstance());
        this.getRegistryManager().addRegistry(IInfoBookRegistry.class, new InfoBookRegistry());
        this.getRegistryManager().addRegistry(IRegistryInventoryLocation.class, RegistryInventoryLocation.getInstance());
    }

    @Override
    protected IClientProxy constructClientProxy() {
        return new ClientProxyNeoForge();
    }

    @Override
    protected ICommonProxy constructCommonProxy() {
        return new CommonProxyNeoForge();
    }

    @Override
    protected ModCompatLoader constructModCompatLoader() {
        ModCompatLoader modCompatLoader = super.constructModCompatLoader();
        modCompatLoader.addModCompat(new ModCompatCurios());
        return modCompatLoader;
    }

    @Override
    protected LiteralArgumentBuilder<CommandSourceStack> constructBaseCommand(Commands.CommandSelection selection, CommandBuildContext context) {
        LiteralArgumentBuilder<CommandSourceStack> root = super.constructBaseCommand(selection, context);
        root.then(CommandIgnite.make());
        root.then(CommandDebug.make());
        root.then(CommandReloadResources.make());
        root.then(CommandDumpRegistries.make());
        root.then(CommandInfoBookTest.make());
        return root;
    }

    @Override
    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
        NBTClassTypesNeoForge.load();
        PacketCodecsNeoForge.load();
        RegistryExportables.load();
        this.getRegistryManager().getRegistry(IInfoBookRegistry.class).registerInfoBook(InfoBookTest.getInstance(), "/data/cyclopscore/info/test.xml");
        new GuiContainerOpenTriggerEventHooksNeoForge();
        new ModItemObtainedTriggerEventHooksNeoForge();
        new ItemCraftedTriggerTriggerEventHooksNeoForge();
    }

    @Override
    protected void onServerStarting(ServerStartingEvent event) {
        super.onServerStarting(event);
        ImportantUsers.checkAll();
    }

    @Override
    protected boolean hasDefaultCreativeModeTab() {
        return false;
    }

    @Override
    public void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable(new GeneralConfig(this));
        configHandler.addConfigurable(new ParticleBlurConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new ParticleDropColoredConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new ContainerInfoBookTestConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new ArgumentTypeConfigPropertyConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new ArgumentTypeDebugPacketConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new ArgumentTypeEnumConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new LootModifierInjectItemConfigNeoForge());
        configHandler.addConfigurable(new GuiContainerOpenTriggerConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new ItemCraftedTriggerConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new ModItemObtainedTriggerConfig<CyclopsCoreNeoForge>(this));
        configHandler.addConfigurable(new DataComponentCapacityConfig(this));
        configHandler.addConfigurable(new DataComponentEnergyStorageConfig(this));
        configHandler.addConfigurable(new DataComponentFluidContentConfig());
        configHandler.addConfigurable(new DataComponentInventoryConfig());
        configHandler.addConfigurable(new MethodGameTestInstanceConfig(this));
    }

    @Override
    public Class<?>[] getGameTestClasses() {
        return new Class[]{StartupTestNeoForge.class};
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public static void clog(String message) {
        _instance.log(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.log(level, message);
    }
}

