/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.fluid;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.ItemAccessFluidHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.RegistryEntries;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;

public class FluidHandlerItemCapacity
extends ItemAccessFluidHandler
implements IFluidHandlerCapacity {
    private final Fluid fluid;
    private final int capacityDefault;

    public FluidHandlerItemCapacity(ItemAccess itemAccess, int capacity) {
        this(itemAccess, capacity, null);
    }

    public FluidHandlerItemCapacity(ItemAccess itemAccess, int capacity, Fluid fluid) {
        super(itemAccess, (DataComponentType)RegistryEntries.COMPONENT_FLUID_CONTENT.get(), capacity);
        this.fluid = fluid;
        this.capacityDefault = capacity;
    }

    public boolean isValid(int index, FluidResource resource) {
        return super.isValid(index, resource) && this.fluid == null || this.fluid == resource.getFluid();
    }

    protected ItemResource update(ItemResource accessResource, int index, FluidResource newResource, int newAmount) {
        this.capacity = this.getTankCapacity(0);
        if (newAmount == 0) {
            return accessResource.without(this.component);
        }
        return super.update(accessResource, index, newResource, newAmount);
    }

    @Override
    public void setTankCapacity(int tank, int capacity, TransactionContext transaction) {
        if (capacity == this.capacityDefault) {
            this.itemAccess.exchange(this.itemAccess.getResource().without((DataComponentType)RegistryEntries.COMPONENT_CAPACITY.get()), this.itemAccess.getAmount(), transaction);
        } else {
            this.itemAccess.exchange(this.itemAccess.getResource().with((DataComponentType)RegistryEntries.COMPONENT_CAPACITY.get(), (Object)capacity), this.itemAccess.getAmount(), transaction);
        }
        this.capacity = capacity;
    }

    @Override
    public int getTankCapacity(int tank) {
        return (Integer)this.itemAccess.getResource().getOrDefault(RegistryEntries.COMPONENT_CAPACITY, (Object)this.capacity);
    }

    protected int getCapacity(int index, FluidResource resource) {
        return this.getTankCapacity(index);
    }

    public long getCapacityAsLong(int index, FluidResource resource) {
        return this.getTankCapacity(index);
    }

    public int getCapacityAsInt(int index, FluidResource resource) {
        return this.getTankCapacity(index);
    }
}

