/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.capability.fluid;

import java.util.Objects;
import javax.annotation.Nullable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ItemAccessResourceHandler;
import net.neoforged.neoforge.transfer.TransferPreconditions;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class ResourceHandlerFluidSwapEmpty
extends ItemAccessResourceHandler<FluidResource> {
    private final FluidStack fluid;
    private final ItemResource itemResourceFull;
    private final ItemResource itemResourceEmpty;

    public ResourceHandlerFluidSwapEmpty(ItemAccess itemAccess, FluidStack fluid, ItemResource itemResourceFull, ItemResource itemResourceEmpty) {
        super(itemAccess, 1);
        this.fluid = fluid;
        this.itemResourceFull = itemResourceFull;
        this.itemResourceEmpty = itemResourceEmpty;
    }

    protected FluidResource getResourceFrom(ItemResource accessResource, int index) {
        if (this.itemResourceEmpty.is((Object)accessResource.getItem())) {
            return FluidResource.EMPTY;
        }
        return FluidResource.of((FluidStack)this.fluid);
    }

    protected int getAmountFrom(ItemResource accessResource, int index) {
        FluidResource resource = this.getResourceFrom(accessResource, index);
        return resource.isEmpty() ? 0 : this.fluid.getAmount();
    }

    @Nullable
    protected ItemResource update(ItemResource accessResource, int index, FluidResource newResource, int newAmount) {
        if (newAmount == 0) {
            return this.itemResourceEmpty;
        }
        if (newAmount != this.fluid.getAmount()) {
            return null;
        }
        return this.itemResourceFull;
    }

    protected int getCapacity(int index, FluidResource resource) {
        Objects.checkIndex(index, this.size());
        return this.fluid.getAmount();
    }

    public int extract(int index, FluidResource resource, int amount, TransactionContext transaction) {
        ItemResource emptiedResource;
        int currentAmountPerItem;
        int extractedPerItem;
        Objects.checkIndex(index, this.size());
        TransferPreconditions.checkNonEmptyNonNegative((Resource)resource, (int)amount);
        int accessAmount = this.itemAccess.getAmount();
        if (accessAmount == 0) {
            return 0;
        }
        ItemResource accessResource = this.itemAccess.getResource();
        FluidResource currentResource = this.getResourceFrom(accessResource, index);
        if (resource.equals((Object)currentResource) && (extractedPerItem = Math.min(amount / accessAmount, currentAmountPerItem = this.getAmountFrom(accessResource, index))) > 0 && (emptiedResource = this.update(accessResource, index, resource, currentAmountPerItem - extractedPerItem)) != null) {
            if (!emptiedResource.isEmpty()) {
                return extractedPerItem * this.itemAccess.exchange(emptiedResource, accessAmount, transaction);
            }
            return extractedPerItem * this.itemAccess.extract(accessResource, accessAmount, transaction);
        }
        return 0;
    }
}

