/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component;

import java.awt.Point;
import java.awt.Rectangle;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class WidgetScrollBar
extends AbstractWidget {
    private static final Identifier SCROLLER_SPRITE = Identifier.withDefaultNamespace((String)"container/creative_inventory/scroller");
    private static final Identifier SCROLLER_DISABLED_SPRITE = Identifier.withDefaultNamespace((String)"container/creative_inventory/scroller_disabled");
    private static final int SCROLL_BUTTON_HEIGHT = 15;
    private static final int SCROLL_BUTTON_WIDTH = 12;
    private final int height;
    @Nullable
    private final IScrollCallback scrollCallback;
    @Nullable
    private Rectangle scollRegion;
    private int totalRows;
    private int visibleRows;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;

    public WidgetScrollBar(int x, int y, int height, Component narrationMessage, @Nullable IScrollCallback scrollCallback, int visibleRows) {
        this(x, y, height, narrationMessage, scrollCallback, visibleRows, null);
    }

    public WidgetScrollBar(int x, int y, int height, Component narrationMessage, @Nullable IScrollCallback scrollCallback, int visibleRows, Rectangle scollRegion) {
        super(x, y, 12, height, narrationMessage);
        this.height = height;
        this.scrollCallback = scrollCallback;
        this.scollRegion = scollRegion;
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.wasClicking = false;
        this.setVisibleRows(visibleRows);
    }

    public void setScollRegion(@Nullable Rectangle scollRegion) {
        this.scollRegion = scollRegion;
    }

    public boolean isMouseOverRegion(double x, double y) {
        if (this.scollRegion != null && IModHelpers.get().getRenderHelpers().isPointInRegion(this.scollRegion, new Point((int)x, (int)y))) {
            return true;
        }
        return super.isMouseOver(x, y);
    }

    public float getCurrentScroll() {
        return this.currentScroll;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY != 0.0 && this.needsScrollBars()) {
            this.scrollRelative(scrollY);
            return true;
        }
        return false;
    }

    public boolean mouseDragged(MouseButtonEvent mouse, double offsetX, double offsetY) {
        boolean flag = mouse.button() == 0 || mouse.button() == 1;
        int xMax = this.getX() + 14;
        int yMax = this.getY() + this.height;
        if (!this.needsScrollBars()) {
            this.scrollTo(0.0f);
            return true;
        }
        if (!this.wasClicking && flag && mouse.x() >= (double)this.getX() && mouse.y() >= (double)this.getY() && mouse.x() < (double)xMax && mouse.y() < (double)yMax) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouse.y() - (double)this.getY()) - 7.5f) / ((float)(yMax - this.getY()) - 15.0f);
            this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
            this.scrollTo(this.currentScroll);
            return true;
        }
        return false;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int scrollX = this.getX();
        int scrollMinY = this.getY();
        int scrollMaxY = scrollMinY + this.height;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, this.needsScrollBars() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE, scrollX, scrollMinY + (int)((float)(scrollMaxY - scrollMinY - 15 - 2) * this.currentScroll), 12, 15);
    }

    protected boolean needsScrollBars() {
        return this.getTotalRows() > this.getVisibleRows();
    }

    protected int getScrollStep() {
        return this.getTotalRows() - this.getVisibleRows();
    }

    public void scrollRelative(double step) {
        float scroll = (float)((double)this.currentScroll - step / (double)this.getScrollStep());
        scroll = Mth.clamp((float)scroll, (float)0.0f, (float)1.0f);
        this.scrollTo(scroll);
    }

    public void scrollTo(float scroll) {
        this.scrollTo(scroll, true);
    }

    public void scrollTo(float scroll, boolean invokeCallback) {
        this.currentScroll = Math.max(0.0f, scroll);
        if (invokeCallback && this.scrollCallback != null) {
            int firstRow = (int)((double)(scroll * (float)this.getScrollStep()) + 0.5);
            this.scrollCallback.onScroll(firstRow);
        }
    }

    public void setFirstRow(int firstRow, boolean invokeCallback) {
        float scroll = (float)firstRow / (float)this.getScrollStep();
        scroll = Mth.clamp((float)scroll, (float)0.0f, (float)1.0f);
        this.scrollTo(scroll, invokeCallback);
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getVisibleRows() {
        return this.visibleRows;
    }

    public void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public static interface IScrollCallback {
        public void onScroll(int var1);
    }
}

