/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import java.awt.Color;
import java.util.List;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.quad.BakedColors;
import net.neoforged.neoforge.client.model.quad.BakedNormals;
import net.neoforged.neoforge.model.data.ModelData;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class DynamicBaseModel
implements BlockStateModel {
    protected static final float[][] ROTATION_UV = new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}};
    protected static final int[] ROTATION_FIX = new int[]{2, 0, 2, 0, 1, 3};
    protected static final float[][] UVS = new float[][]{{0.0f, 0.0f}, {1.0f, 1.0f}};

    protected static Vector3f rotate(Vector3f vec, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vector3f(vec.x, -vec.y, -vec.z);
            }
            case UP: {
                return new Vector3f(vec.x, vec.y, vec.z);
            }
            case NORTH: {
                return new Vector3f(vec.x, vec.z, -vec.y);
            }
            case SOUTH: {
                return new Vector3f(vec.x, -vec.z, vec.y);
            }
            case WEST: {
                return new Vector3f(-vec.y, vec.x, vec.z);
            }
            case EAST: {
                return new Vector3f(vec.y, -vec.x, vec.z);
            }
        }
        return vec;
    }

    protected static Vec3 revRotate(Vec3 vec, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vec3(vec.x, -vec.y, -vec.z);
            }
            case UP: {
                return new Vec3(vec.x, vec.y, vec.z);
            }
            case NORTH: {
                return new Vec3(vec.x, -vec.z, vec.y);
            }
            case SOUTH: {
                return new Vec3(vec.x, vec.z, -vec.y);
            }
            case WEST: {
                return new Vec3(vec.y, -vec.x, vec.z);
            }
            case EAST: {
                return new Vec3(-vec.y, vec.x, vec.z);
            }
        }
        return vec;
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, -1, side);
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, false);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Color shadeColor, Direction side) {
        int color = IModHelpers.get().getBaseHelpers().RGBAToInt(shadeColor.getBlue(), shadeColor.getGreen(), shadeColor.getRed(), shadeColor.getAlpha());
        DynamicBaseModel.addColoredBakedQuad(quads, x1, x2, z1, z2, y, texture, color, side);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, true);
    }

    private static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side, boolean isColored) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, 0, isColored, shadeColor, new float[][]{{x1, z1}, {x1, z2}, {x2, z2}, {x2, z1}});
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side, int rotation) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, rotation, false, -1, ROTATION_UV);
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side, int rotation, boolean isColored, int shadeColor, float[][] uvs) {
        Vector3f v1 = DynamicBaseModel.rotate(new Vector3f(x1 - 0.5f, y - 0.5f, z1 - 0.5f), side).add(0.5f, 0.5f, 0.5f);
        Vector3f v2 = DynamicBaseModel.rotate(new Vector3f(x1 - 0.5f, y - 0.5f, z2 - 0.5f), side).add(0.5f, 0.5f, 0.5f);
        Vector3f v3 = DynamicBaseModel.rotate(new Vector3f(x2 - 0.5f, y - 0.5f, z2 - 0.5f), side).add(0.5f, 0.5f, 0.5f);
        Vector3f v4 = DynamicBaseModel.rotate(new Vector3f(x2 - 0.5f, y - 0.5f, z1 - 0.5f), side).add(0.5f, 0.5f, 0.5f);
        quads.add(new BakedQuad((Vector3fc)v1, (Vector3fc)v2, (Vector3fc)v3, (Vector3fc)v4, UVPair.pack((float)texture.getU(uvs[(0 + rotation) % 4][0]), (float)texture.getV(uvs[(0 + rotation) % 4][1])), UVPair.pack((float)texture.getU(uvs[(1 + rotation) % 4][0]), (float)texture.getV(uvs[(1 + rotation) % 4][1])), UVPair.pack((float)texture.getU(uvs[(2 + rotation) % 4][0]), (float)texture.getV(uvs[(2 + rotation) % 4][1])), UVPair.pack((float)texture.getU(uvs[(3 + rotation) % 4][0]), (float)texture.getV(uvs[(3 + rotation) % 4][1])), -1, side, texture, false, 0, BakedNormals.UNSPECIFIED, isColored ? BakedColors.of((int)shadeColor) : BakedColors.DEFAULT, true));
    }

    public abstract List<BakedQuad> handleBlockState(BlockAndTintGetter var1, BlockPos var2, BlockState var3, Direction var4, RandomSource var5, ModelData var6, ChunkSectionLayer var7);

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        ModelData extraData = this.getModelData(level, pos, state, level.getModelData(pos));
        for (ChunkSectionLayer renderType : this.getRenderTypes(state, random, extraData)) {
            for (Direction side : Direction.values()) {
                QuadCollection.Builder quadCollectionBuilder = new QuadCollection.Builder();
                for (BakedQuad blockStateQuad : this.handleBlockState(level, pos, state, side, random, extraData, renderType)) {
                    quadCollectionBuilder = quadCollectionBuilder.addCulledFace(side, blockStateQuad);
                }
                parts.add((BlockModelPart)new SimpleModelWrapper(quadCollectionBuilder.build(), this.usesBlockLight(), this.particleIcon(level, pos, state), renderType));
            }
        }
    }

    public void collectParts(RandomSource random, List<BlockModelPart> output) {
    }

    public abstract ModelData getModelData(BlockAndTintGetter var1, BlockPos var2, BlockState var3, ModelData var4);

    public abstract List<ChunkSectionLayer> getRenderTypes(BlockState var1, RandomSource var2, ModelData var3);

    public abstract boolean usesBlockLight();
}

