/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import com.mojang.datafixers.util.Either;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class DeferredHolderCommon<R, T extends R>
implements Holder<R> {
    public static Function<ResourceKey<?>, Holder<?>> BIND_OVERRIDE = null;
    protected final ResourceKey<R> key;
    @Nullable
    private Holder<R> holder = null;

    public static <R, T extends R> DeferredHolderCommon<R, T> create(ResourceKey<? extends Registry<R>> registryKey, Identifier valueName) {
        return DeferredHolderCommon.create(ResourceKey.create(registryKey, (Identifier)valueName));
    }

    public static <R, T extends R> DeferredHolderCommon<R, T> create(Identifier registryName, Identifier valueName) {
        return DeferredHolderCommon.create(ResourceKey.createRegistryKey((Identifier)registryName), valueName);
    }

    public static <R, T extends R> DeferredHolderCommon<R, T> create(ResourceKey<R> key) {
        return new DeferredHolderCommon<R, T>(key);
    }

    protected DeferredHolderCommon(ResourceKey<R> key) {
        this.key = Objects.requireNonNull(key);
        this.bind(false);
    }

    public Supplier<T> getSupplier() {
        return this::value;
    }

    public T value() {
        this.bind(true);
        if (this.holder == null) {
            throw new NullPointerException("Trying to access unbound value: " + String.valueOf(this.key));
        }
        return (T)this.holder.value();
    }

    public Optional<T> asOptional() {
        return this.isBound() ? Optional.of(this.value()) : Optional.empty();
    }

    @Nullable
    protected Registry<R> getRegistry() {
        return (Registry)BuiltInRegistries.REGISTRY.getValue(this.key.registry());
    }

    protected final void bind(boolean throwOnMissingRegistry) {
        Registry<R> registry;
        if (this.holder != null) {
            return;
        }
        if (BIND_OVERRIDE != null) {
            this.holder = BIND_OVERRIDE.apply(this.key);
            if (this.holder != null) {
                return;
            }
        }
        if ((registry = this.getRegistry()) != null) {
            this.holder = registry.get(this.key).orElse(null);
        } else if (throwOnMissingRegistry) {
            throw new IllegalStateException("Registry not present for " + String.valueOf(this) + ": " + String.valueOf(this.key.registry()));
        }
    }

    public Identifier getId() {
        return this.key.identifier();
    }

    public ResourceKey<R> getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        Holder h;
        if (this == obj) {
            return true;
        }
        return obj instanceof Holder && (h = (Holder)obj).kind() == Holder.Kind.REFERENCE && h.unwrapKey().orElseThrow() == this.key;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "DeferredHolder{%s}", this.key);
    }

    public boolean isBound() {
        this.bind(false);
        return this.holder != null && this.holder.isBound();
    }

    public boolean is(Identifier id) {
        return id.equals((Object)this.key.identifier());
    }

    public boolean is(ResourceKey<R> key) {
        return key == this.key;
    }

    public boolean is(Predicate<ResourceKey<R>> filter) {
        return filter.test(this.key);
    }

    public boolean is(TagKey<R> tag) {
        this.bind(false);
        return this.holder != null && this.holder.is(tag);
    }

    @Deprecated
    public boolean is(Holder<R> holder) {
        this.bind(false);
        return this.holder != null && this.holder.is(holder);
    }

    public Stream<TagKey<R>> tags() {
        this.bind(false);
        return this.holder != null ? this.holder.tags() : Stream.empty();
    }

    public Either<ResourceKey<R>, R> unwrap() {
        return Either.left(this.key);
    }

    public Optional<ResourceKey<R>> unwrapKey() {
        return Optional.of(this.key);
    }

    public Holder.Kind kind() {
        return Holder.Kind.REFERENCE;
    }

    public boolean canSerializeIn(HolderOwner<R> owner) {
        this.bind(false);
        return this.holder != null && this.holder.canSerializeIn(owner);
    }
}

