/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.net.URI;
import net.minecraft.util.Util;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.helper.IBaseHelpers;

public class BaseHelpersCommon
implements IBaseHelpers {
    @Override
    public Object tryParse(String newValue, Object oldValue) {
        Object newValueParsed = null;
        try {
            if (oldValue instanceof Integer) {
                newValueParsed = Integer.parseInt(newValue);
            } else if (oldValue instanceof Boolean) {
                newValueParsed = Boolean.parseBoolean(newValue);
            } else if (oldValue instanceof Double) {
                newValueParsed = Double.parseDouble(newValue);
            } else if (oldValue instanceof String) {
                newValueParsed = newValue;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newValueParsed;
    }

    @Override
    public int RGBToInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    @Override
    public int RGBAToInt(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    @Override
    public int addAlphaToColor(int color, int alpha) {
        return alpha << 24 | color;
    }

    @Override
    public int addAlphaToColor(int color, float alpha) {
        return this.addAlphaToColor(color, Math.round(alpha * 255.0f));
    }

    @Override
    public Triple<Float, Float, Float> intToRGB(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        return Triple.of((Object)Float.valueOf(red), (Object)Float.valueOf(green), (Object)Float.valueOf(blue));
    }

    @Override
    public int rgbToBgra(int color, int alpha) {
        Triple<Float, Float, Float> triple = this.intToRGB(color);
        return this.RGBAToInt((int)(((Float)triple.getRight()).floatValue() * 255.0f), (int)(((Float)triple.getMiddle()).floatValue() * 255.0f), (int)(((Float)triple.getLeft()).floatValue() * 255.0f), alpha);
    }

    @Override
    public int rgbToBgr(int color) {
        return this.rgbToBgra(color, 255);
    }

    @Override
    public int addSafe(int a, int b) {
        int sum = a + b;
        if (sum < a || sum < b) {
            return Integer.MAX_VALUE;
        }
        return sum;
    }

    @Override
    public int multiplySafe(int a, int b) {
        int mul = a * b;
        if (a > 0 && b > 0 && (mul < a || mul < b)) {
            return Integer.MAX_VALUE;
        }
        return mul;
    }

    @Override
    public int castSafe(long value) {
        int casted = (int)value;
        if ((long)casted != value) {
            return Integer.MAX_VALUE;
        }
        return casted;
    }

    @Override
    public void openUrl(String url) {
        try {
            URI uri = new URI(url);
            Util.getPlatform().openUri(uri);
        }
        catch (Throwable e) {
            e.printStackTrace();
            CyclopsCoreInstance.MOD.log(Level.ERROR, e.getMessage());
        }
    }
}

