/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ICraftingHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class CraftingHelpersCommon
implements ICraftingHelpers {
    private final IModHelpers modHelpers;
    private final LoadingCache<Triple<RecipeType<?>, CacheableCraftingInventory, Identifier>, Optional<RecipeHolder<? extends Recipe>>> CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<RecipeType<?>, CacheableCraftingInventory, Identifier>, Optional<RecipeHolder<? extends Recipe>>>(){

        public Optional<RecipeHolder<? extends Recipe>> load(Triple<RecipeType<?>, CacheableCraftingInventory, Identifier> key) throws Exception {
            ServerLevel world = CraftingHelpersCommon.this.modHelpers.getMinecraftHelpers().getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (Identifier)((Identifier)key.getRight())));
            return world.recipeAccess().getRecipeFor((RecipeType)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (Level)world);
        }
    });

    public CraftingHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public RecipeManager getRecipeManager() {
        return Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().getLevel(Level.OVERWORLD), "Server is still loading").recipeAccess();
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> getRecipe(RecipeType<T> recipeType, ResourceKey<Recipe<?>> recipeName) {
        return Optional.ofNullable(this.getRecipeManager().byKeyTyped(recipeType, recipeName));
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> findRecipe(RecipeType<T> recipeType, C container, Level world) {
        return ((RecipeManager)world.recipeAccess()).getRecipeFor(recipeType, container, world);
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findRecipes(RecipeType<? extends T> recipeType) {
        return this.findRecipes(Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().getLevel(Level.OVERWORLD)), recipeType);
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findRecipes(ServerLevel world, RecipeType<? extends T> recipeType) {
        return (List)world.recipeAccess().recipes.byType(recipeType);
    }

    @Override
    public List<RecipeDisplayEntry> getRecipeDisplays(RecipeType<?> recipeType, ResourceKey<Recipe<?>> recipeName) {
        ArrayList displays = Lists.newArrayList();
        this.modHelpers.getMinecraftHelpers().getCurrentServer().overworld().recipeAccess().listDisplaysForRecipe(recipeName, displays::add);
        return displays;
    }

    @Override
    public List<Pair<Identifier, RecipeDisplayEntry>> getRecipeDisplays(RecipeType<?> recipeType, String recipeNameRegex) {
        ArrayList displays = Lists.newArrayList();
        for (Map.Entry entry : this.modHelpers.getMinecraftHelpers().getCurrentServer().overworld().recipeAccess().recipeToDisplay.entrySet()) {
            if (!recipeNameRegex.isEmpty() && !((ResourceKey)entry.getKey()).identifier().toString().matches(recipeNameRegex)) continue;
            for (RecipeManager.ServerDisplayInfo display : (List)entry.getValue()) {
                displays.add(Pair.of((Object)display.parent().id().identifier(), (Object)display.display()));
            }
        }
        return displays;
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> findRecipeCached(RecipeType<T> recipeType, C inventoryCrafting, Level world, boolean uniqueInventory) {
        return (Optional)this.CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.dimension().identifier()));
    }

    public class CacheableCraftingInventory {
        private final RecipeInput inventoryCrafting;

        public CacheableCraftingInventory(RecipeInput inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                int width = inventoryCrafting.size();
                int height = 1;
                if (inventoryCrafting instanceof CraftingInput) {
                    width = ((CraftingInput)inventoryCrafting).width();
                    height = ((CraftingInput)inventoryCrafting).height();
                }
                int size = inventoryCrafting.size();
                NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
                for (int i = 0; i < inventoryCrafting.size(); ++i) {
                    items.set(i, (Object)inventoryCrafting.getItem(i).copy());
                }
                this.inventoryCrafting = CraftingInput.of((int)width, (int)height, (List)items);
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public RecipeInput getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            RecipeInput otherInput = ((CacheableCraftingInventory)obj).getInventoryCrafting();
            RecipeInput recipeInput = this.getInventoryCrafting();
            if (recipeInput instanceof CraftingInput) {
                CraftingInput craftingInputThis = (CraftingInput)recipeInput;
                if (!(otherInput instanceof CraftingInput)) return false;
                CraftingInput craftingInputOther = (CraftingInput)otherInput;
                if (craftingInputThis.width() != craftingInputOther.width() || craftingInputThis.height() != craftingInputOther.height()) {
                    return false;
                }
            } else if (this.getInventoryCrafting().size() != otherInput.size()) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().size(); ++i) {
                if (ItemStack.isSameItemSameComponents((ItemStack)this.getInventoryCrafting().getItem(i), (ItemStack)otherInput.getItem(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().size();
            RecipeInput recipeInput = this.getInventoryCrafting();
            if (recipeInput instanceof CraftingInput) {
                CraftingInput craftingInput = (CraftingInput)recipeInput;
                hash = 23 + 3 * craftingInput.width() + 5 * craftingInput.height();
            }
            for (int i = 0; i < this.getInventoryCrafting().size(); ++i) {
                hash |= CraftingHelpersCommon.this.modHelpers.getItemStackHelpers().getItemStackHashCode(this.getInventoryCrafting().getItem(i)) * i;
            }
            return hash;
        }
    }
}

