/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.Identifier;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.EventHooks;

public class EntityHelpers {
    public static final String NBTTAG_ID = "id";

    public static void onEntityCollided(Level world, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (blockPos != null) {
            Block block = world.getBlockState(blockPos).getBlock();
            block.stepOn(world, blockPos, blockState, entity);
        }
    }

    public static List<Entity> getEntitiesInArea(Level world, BlockPos blockPos, int area) {
        AABB box = new AABB((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ()).inflate((double)area, (double)area, (double)area);
        List entities = world.getEntitiesOfClass(Entity.class, box);
        return entities;
    }

    public static Optional<Entity> spawnEntity(Level world, @Nullable Identifier entityName, double x, double y, double z, EntitySpawnReason spawnReason) {
        return EntityType.byString((String)entityName.toString()).map(type -> {
            Entity entity = type.create(world, spawnReason);
            entity.setPos(x, y, z);
            world.addFreshEntity(entity);
            return entity;
        });
    }

    public static boolean spawnEntity(ServerLevelAccessor world, Mob entityLiving, EntitySpawnReason spawnReason) {
        SpawnGroupData spawnData = EventHooks.finalizeMobSpawn((Mob)entityLiving, (ServerLevelAccessor)world, (DifficultyInstance)world.getCurrentDifficultyAt(entityLiving.blockPosition()), (EntitySpawnReason)spawnReason, null);
        if (spawnData != null) {
            world.addFreshEntity((Entity)entityLiving);
            return true;
        }
        return false;
    }

    public static Vec3i getEntitySize(Entity entity) {
        int x = (int)Math.ceil(entity.getBbWidth());
        int y = (int)Math.ceil(entity.getBbHeight());
        int z = x;
        return new Vec3i(x, y, z);
    }

    public static void spawnXpAtPlayer(Level world, Player player, int xp) {
        if (!world.isClientSide()) {
            while (xp > 0) {
                int current = ExperienceOrb.getExperienceValue((int)xp);
                xp -= current;
                world.addFreshEntity((Entity)new ExperienceOrb(world, player.getX(), player.getY() + 0.5, player.getZ() + 0.5, current));
            }
        }
    }

    public static CompoundTag getPersistedPlayerNbt(Player player) {
        CompoundTag tag = player.getPersistentData();
        CompoundTag persistedTag = tag.getCompound("PlayerPersisted").orElse(null);
        if (persistedTag == null) {
            persistedTag = new CompoundTag();
            tag.put("PlayerPersisted", (Tag)persistedTag);
        }
        return persistedTag;
    }
}

