/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Function;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.cyclops.cyclopscore.helper.IRenderHelpers;
import org.joml.Matrix3x2f;

public class RenderHelpersCommon
implements IRenderHelpers {
    private static final Random rand = new Random();
    private static final Function<Identifier, TextureAtlasSprite> TEXTURE_GETTER = location -> Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(Identifier.fromNamespaceAndPath((String)"minecraft", (String)"blocks")).getSprite(location);

    @Override
    public void emitParticle(Particle particle) {
        Minecraft.getInstance().particleEngine.add(particle);
    }

    @Override
    public void drawScaledString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)x, (float)y, (Matrix3x2f)guiGraphics.pose());
        guiGraphics.pose().scale(scale, scale, (Matrix3x2f)guiGraphics.pose());
        guiGraphics.drawString(fontRenderer, string, 0, 0, color, shadow);
        guiGraphics.pose().popMatrix();
    }

    @Override
    public void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        this.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, maxWidth, 1.0f, maxWidth, color, shadow, displayMode);
    }

    @Override
    public void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int width, float originalScale, int maxWidth, int color, boolean shadow, Font.DisplayMode displayMode) {
        float originalWidth = (float)fontRenderer.width(string) * originalScale;
        float scale = Math.min(originalScale, (float)maxWidth / originalWidth * originalScale);
        this.drawScaledCenteredString(guiGraphics, fontRenderer, string, x, y, width, scale, color, shadow, displayMode);
    }

    @Override
    public void drawScaledCenteredString(GuiGraphics guiGraphics, Font fontRenderer, String string, int x, int y, int width, float scale, int color, boolean shadow, Font.DisplayMode displayMode) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().scale(scale, scale, (Matrix3x2f)guiGraphics.pose());
        int titleLength = fontRenderer.width(string);
        Objects.requireNonNull(fontRenderer);
        int titleHeight = 9;
        guiGraphics.drawString(fontRenderer, string, Math.round((float)(x + width / 2) / scale - (float)(titleLength / 2)), Math.round((float)y / scale - (float)(titleHeight / 2)), color, false);
        guiGraphics.pose().popMatrix();
    }

    @Override
    public BlockStateModel getBakedModel(BlockState blockState) {
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher blockRendererDispatcher = mc.getBlockRenderer();
        BlockModelShaper blockModelShapes = blockRendererDispatcher.getBlockModelShaper();
        return blockModelShapes.getBlockModel(blockState);
    }

    @Override
    public BlockStateModel getDynamicBakedModel(Level world, BlockPos pos) {
        return this.getBakedModel(world.getBlockState(pos));
    }

    @Override
    public void addBlockHitEffects(ParticleEngine particleManager, ClientLevel world, BlockState blockState, BlockPos pos, Direction side) {
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            int i = pos.getX();
            int j = pos.getY();
            int k = pos.getZ();
            float f = 0.1f;
            AABB bb = blockState.getShape((BlockGetter)world, pos).bounds();
            double d0 = (double)i + rand.nextDouble() * (bb.maxX - bb.minX - (double)(f * 2.0f)) + (double)f + bb.minX;
            double d1 = (double)j + rand.nextDouble() * (bb.maxY - bb.minY - (double)(f * 2.0f)) + (double)f + bb.minY;
            double d2 = (double)k + rand.nextDouble() * (bb.maxZ - bb.minZ - (double)(f * 2.0f)) + (double)f + bb.minZ;
            if (side == Direction.DOWN) {
                d1 = (double)j + bb.minY - (double)f;
            }
            if (side == Direction.UP) {
                d1 = (double)j + bb.maxY + (double)f;
            }
            if (side == Direction.NORTH) {
                d2 = (double)k + bb.minZ - (double)f;
            }
            if (side == Direction.SOUTH) {
                d2 = (double)k + bb.maxZ + (double)f;
            }
            if (side == Direction.WEST) {
                d0 = (double)i + bb.minX - (double)f;
            }
            if (side == Direction.EAST) {
                d0 = (double)i + bb.maxX + (double)f;
            }
            particleManager.add(particleManager.createParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), d0, d1, d2, 0.0, 0.0, 0.0));
        }
    }

    @Override
    public Function<Identifier, TextureAtlasSprite> getBlockTextureGetter() {
        return TEXTURE_GETTER;
    }

    @Override
    public TextureAtlasSprite getBlockIcon(Block block) {
        return Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(block.defaultBlockState());
    }

    @Override
    public boolean isPointInRegion(int left, int top, int width, int height, double pointX, double pointY) {
        return pointX >= (double)left && pointX < (double)(left + width) && pointY >= (double)top && pointY < (double)(top + height);
    }

    @Override
    public boolean isPointInRegion(Rectangle region, Point point) {
        return this.isPointInRegion(region.x, region.y, region.width, region.height, point.x, point.y);
    }

    @Override
    public boolean isPointInButton(Button button, int pointX, int pointY) {
        return this.isPointInRegion(button.getX(), button.getY(), button.getWidth(), button.getHeight(), pointX, pointY);
    }

    @Override
    public void blitColored(GuiGraphics guiGraphics, Identifier texture, int x, int y, float u, float v, int width, int height, float r, float g, float b, float a) {
        this.blitColored(guiGraphics, texture, x, y, u, v, width, height, 256, 256, r, g, b, a);
    }

    @Override
    public void blitColored(GuiGraphics guiGraphics, Identifier texture, int x, int y, float u, float v, int width, int height, int textureWidth, int textureHeight, float r, float g, float b, float a) {
        int color = ARGB.colorFromFloat((float)a, (float)r, (float)g, (float)b);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, x, y, u, v, width, height, textureWidth, textureHeight, color);
    }

    @Override
    public void renderLineBox(PoseStack poseStack, VertexConsumer buffer, AABB box, float red, float green, float blue, float alpha, float width) {
        this.renderLineBox(poseStack, buffer, box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, red, green, blue, alpha, red, green, blue, width);
    }

    @Override
    public void renderLineBox(PoseStack poseStack, VertexConsumer consumer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, float red, float green, float blue, float alpha, float red2, float green2, float blue2, float width) {
        PoseStack.Pose posestack$pose = poseStack.last();
        float f = (float)minX;
        float f1 = (float)minY;
        float f2 = (float)minZ;
        float f3 = (float)maxX;
        float f4 = (float)maxY;
        float f5 = (float)maxZ;
        consumer.addVertex(posestack$pose, f, f1, f2).setColor(red, green2, blue2, alpha).setLineWidth(width).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f1, f2).setColor(red, green2, blue2, alpha).setLineWidth(width).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f1, f2).setColor(red2, green, blue2, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f4, f2).setColor(red2, green, blue2, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f1, f2).setColor(red2, green2, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(posestack$pose, f, f1, f5).setColor(red2, green2, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(posestack$pose, f3, f1, f2).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f4, f2).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f4, f2).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f4, f2).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, -1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f4, f2).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(posestack$pose, f, f4, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(posestack$pose, f, f4, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f1, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, -1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f, f1, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f1, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f1, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(posestack$pose, f3, f1, f2).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, -1.0f);
        consumer.addVertex(posestack$pose, f, f4, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f4, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 1.0f, 0.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f1, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f4, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(posestack$pose, f3, f4, f2).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
        consumer.addVertex(posestack$pose, f3, f4, f5).setColor(red, green, blue, alpha).setLineWidth(width).setNormal(posestack$pose, 0.0f, 0.0f, 1.0f);
    }
}

