/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.Identifier;
import net.neoforged.api.distmarker.Dist;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;

public class AdvancementButton
extends AdvancedButton {
    private final Identifier advancementId;

    public AdvancementButton(Identifier advancementId) {
        this.advancementId = advancementId;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
        super.renderTooltip(guiGraphics, font, mx, my);
        if (mx >= this.getX() && my >= this.getY() && mx <= this.getX() + 16 && my <= this.getY() + 16) {
            ArrayList lines = Lists.newArrayList();
            AdvancementHolder advancement = AdvancementHelpers.getAdvancement(Dist.CLIENT, this.advancementId);
            if (advancement != null) {
                advancement.value().display().ifPresent(display -> {
                    lines.add(display.getTitle().getVisualOrderText());
                    lines.add(display.getDescription().getVisualOrderText());
                });
            }
            guiGraphics.setTooltipForNextFrame(font, (List)lines, mx, my);
        }
    }
}

