/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import java.awt.Point;
import java.util.Map;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewardsAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendixClient;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendixClient;

public class AdvancementRewardsAppendixClient
extends SectionAppendixClient<AdvancementRewardsAppendix> {
    protected AdvancementRewardsAppendixClient(AdvancementRewardsAppendix sectionAppendix) {
        super(sectionAppendix);
    }

    @Override
    protected void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        this.requestAdvancementInfo();
        int offsetX = 0;
        int offsetY = 0;
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1, ((AdvancementRewardsAppendix)this.getSectionAppendix()).getWidth() + 2, ((AdvancementRewardsAppendix)this.getSectionAppendix()).getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize("gui.advancements", new Object[0]), x, y - 2, width, 0.9f, gui.getBannerWidth() - 6, IModHelpers.get().getBaseHelpers().RGBAToInt(30, 20, 120, 255));
        offsetY += 10;
        boolean allAchievementsValid = true;
        Map<AdvancedButtonEnum, AdvancedButton> renderButtonHolders = ((AdvancementRewardsAppendix)this.getSectionAppendix()).getRenderButtonHolders();
        AdvancedButtonEnum[] advancements = ((AdvancementRewardsAppendix)this.getSectionAppendix()).getAdvancements();
        for (int i = 0; i < ((AdvancementRewardsAppendix)this.getSectionAppendix()).getAdvancementRewards().getAdvancements().size(); ++i) {
            Identifier advancementId = ((AdvancementRewardsAppendix)this.getSectionAppendix()).getAdvancementRewards().getAdvancements().get(i);
            AdvancementHolder advancement = AdvancementHelpers.getAdvancement(Dist.CLIENT, advancementId);
            if (offsetX + 16 > 80) {
                offsetY += 20;
                offsetX = 0;
            }
            if (advancement == null) {
                allAchievementsValid = false;
                Images.LOCKED.draw(guiGraphics, x + offsetX + 2, y + offsetY + 1);
                renderButtonHolders.get(advancements[i]).update(x + offsetX, y + offsetY, (Component)Component.literal((String)""), null, gui);
                continue;
            }
            int finalOffsetX = offsetX;
            int finalOffsetY = offsetY;
            advancement.value().display().ifPresent(display -> RecipeAppendixClient.renderItemForButton(gui, guiGraphics, x + finalOffsetX, y + finalOffsetY, display.getIcon(), mx, my, true, null));
            if (AdvancementHelpers.hasAdvancementUnlocked((Player)Minecraft.getInstance().player, advancementId)) {
                Images.OK.draw(guiGraphics, x + offsetX + 1, y + offsetY + 2);
            } else {
                allAchievementsValid = false;
            }
            renderButtonHolders.get(advancements[i]).update(x + offsetX, y + offsetY, (Component)Component.literal((String)""), null, gui);
            offsetX += 20;
        }
        boolean taken = ((AdvancementRewardsAppendix)this.getSectionAppendix()).getAdvancementRewards().isObtained((Player)Minecraft.getInstance().player);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2 + (offsetY += 26));
        boolean hovering = mx > x && mx < x + ((AdvancementRewardsAppendix)this.getSectionAppendix()).getWidth() && my > y + offsetY - 10 && my < y + offsetY + 5;
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize("gui." + ((AdvancementRewardsAppendix)this.getSectionAppendix()).getInfoBook().getMod().getModId() + ".rewards", new Object[0]), x, y - 2 + offsetY, width, 0.9f, gui.getBannerWidth() - 6, IModHelpers.get().getBaseHelpers().RGBAToInt(30, 20, 120, 255));
        renderButtonHolders.get(AdvancementRewardsAppendix.COLLECT).update(x, y - 8 + offsetY, (Component)Component.literal((String)""), null, gui);
        if (allAchievementsValid && !taken) {
            float g = hovering ? 1.0f : (float)(gui.getTick() % 20) / 20.0f * 0.4f + 0.6f;
            float r = hovering ? 0.2f : 0.7f;
            float b = hovering ? 0.2f : 0.7f;
            Images.ARROW_DOWN.drawWithColor(guiGraphics, x, y + offsetY - 11, r, g, b, 1.0f);
            Images.ARROW_DOWN.drawWithColor(guiGraphics, x + 60, y + offsetY - 11, r, g, b, 1.0f);
        }
        offsetY += 10;
        Point[] rewardPositions = ((AdvancementRewardsAppendix)this.getSectionAppendix()).getRewardPositions();
        for (int i = 0; i < ((AdvancementRewardsAppendix)this.getSectionAppendix()).getAdvancementRewards().getRewards().size(); ++i) {
            ((AdvancementRewardsAppendix)this.getSectionAppendix()).getAdvancementRewards().getRewards().get(i).constructRewardClient().drawElementInner(gui, guiGraphics, x + rewardPositions[i].x, y + rewardPositions[i].y + offsetY, width, height, page, mx, my, renderButtonHolders.get(((AdvancementRewardsAppendix)this.getSectionAppendix()).getRewards()[i]));
            if (taken) {
                Images.OK.draw(guiGraphics, x + rewardPositions[i].x + 1, y + rewardPositions[i].y + offsetY + 2);
                continue;
            }
            if (allAchievementsValid) continue;
            Images.ERROR.draw(guiGraphics, x + rewardPositions[i].x + 1, y + rewardPositions[i].y + offsetY + 2);
        }
    }

    @Override
    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(gui, guiGraphics, mx, my);
    }

    protected void requestAdvancementInfo() {
        if (Minecraft.getInstance().level.getGameTime() - ((AdvancementRewardsAppendix)this.getSectionAppendix()).lastAdvancementInfoRequest > 60L) {
            ((AdvancementRewardsAppendix)this.getSectionAppendix()).getAdvancementRewards().getAdvancements().forEach(AdvancementHelpers::requestAdvancementUnlockInfo);
            ((AdvancementRewardsAppendix)this.getSectionAppendix()).lastAdvancementInfoRequest = Minecraft.getInstance().level.getGameTime();
        }
    }

    protected void renderToolTips(ScreenInfoBook gui, GuiGraphics guiGraphics, int mx, int my) {
        for (AdvancedButton button : ((AdvancementRewardsAppendix)this.getSectionAppendix()).getRenderButtonHolders().values()) {
            button.renderTooltip(guiGraphics, gui.getFont(), mx, my);
        }
    }
}

