/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.storage;

import java.util.Iterator;
import javax.annotation.Nonnull;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollapsedCollectionMutable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;

public class IngredientComponentStorageCollectionWrapper<T, M>
implements IIngredientComponentStorage<T, M> {
    private final IIngredientCollapsedCollectionMutable<T, M> ingredientCollection;
    private final long maxQuantity;
    private final long rateLimit;
    private final IIngredientMapMutable<T, M, PrototypeInstanceJournal> snapshotJournals;
    private long quantity;

    public IngredientComponentStorageCollectionWrapper(IIngredientCollapsedCollectionMutable<T, M> ingredientCollection) {
        this(ingredientCollection, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public IngredientComponentStorageCollectionWrapper(IIngredientCollapsedCollectionMutable<T, M> ingredientCollection, long maxQuantity, long rateLimit) {
        this.ingredientCollection = ingredientCollection;
        this.maxQuantity = maxQuantity;
        this.rateLimit = rateLimit;
        this.snapshotJournals = new IngredientHashMap<T, M, PrototypeInstanceJournal>(ingredientCollection.getComponent());
        this.quantity = 0L;
    }

    public IngredientComponent<T, M> getComponent() {
        return this.ingredientCollection.getComponent();
    }

    public Iterator<T> iterator() {
        return this.ingredientCollection.iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchCondition) {
        return this.ingredientCollection.iterator(prototype, matchCondition);
    }

    public long getMaxQuantity() {
        return this.maxQuantity;
    }

    T rateLimit(T instance, long allowedQuantity) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        long quantity = matcher.getQuantity(instance);
        long actualQuantity = Math.min(quantity, Math.min(allowedQuantity, this.rateLimit));
        if (actualQuantity == quantity) {
            return instance;
        }
        return (T)matcher.withQuantity(instance, actualQuantity);
    }

    PrototypeInstanceJournal getSnapshotJournal(T ingredient) {
        ingredient = this.getComponent().getMatcher().withQuantity(ingredient, 1L);
        PrototypeInstanceJournal snapshotJournal = (PrototypeInstanceJournal)((Object)this.snapshotJournals.get(ingredient));
        if (snapshotJournal == null) {
            snapshotJournal = new PrototypeInstanceJournal(ingredient);
            this.snapshotJournals.put(ingredient, snapshotJournal);
        }
        return snapshotJournal;
    }

    public T insert(@Nonnull T ingredient, TransactionContext transaction) {
        T insertingIngredient = this.rateLimit(ingredient, this.getMaxQuantity() - this.quantity);
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (!matcher.isEmpty(insertingIngredient)) {
            this.getSnapshotJournal(ingredient).updateSnapshots(transaction);
            boolean added = this.ingredientCollection.add(insertingIngredient);
            if (added) {
                this.quantity += matcher.getQuantity(insertingIngredient);
                return (T)matcher.withQuantity(insertingIngredient, matcher.getQuantity(ingredient) - matcher.getQuantity(insertingIngredient));
            }
        }
        return ingredient;
    }

    public T extract(@Nonnull T prototype, M matchCondition, TransactionContext transaction) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Object toExtract = matcher.getEmptyInstance();
        Iterator<T> it = this.ingredientCollection.iterator(prototype, matcher.withoutCondition(matchCondition, this.getComponent().getPrimaryQuantifier().getMatchCondition()));
        while (it.hasNext()) {
            T t = it.next();
            if (matcher.isEmpty(t)) continue;
            toExtract = t;
            break;
        }
        if (!matcher.matches(prototype, toExtract = this.rateLimit(toExtract, matcher.getQuantity(prototype)), matchCondition)) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        this.getSnapshotJournal(toExtract).updateSnapshots(transaction);
        this.ingredientCollection.remove(toExtract);
        this.quantity -= matcher.getQuantity(toExtract);
        return (T)toExtract;
    }

    public T extract(long maxQuantity, TransactionContext transaction) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        Object toExtract = matcher.getEmptyInstance();
        for (Object t : this.ingredientCollection) {
            if (matcher.isEmpty(t)) continue;
            toExtract = t;
            break;
        }
        toExtract = this.rateLimit(toExtract, maxQuantity);
        this.getSnapshotJournal(toExtract).updateSnapshots(transaction);
        this.ingredientCollection.remove(toExtract);
        this.quantity -= this.getComponent().getMatcher().getQuantity(toExtract);
        return (T)toExtract;
    }

    long getQuantity() {
        return this.quantity;
    }

    void setQuantity(long quantity) {
        this.quantity = quantity;
    }

    class PrototypeInstanceJournal
    extends SnapshotJournal<Long> {
        private final T prototype;

        private PrototypeInstanceJournal(T prototype) {
            this.prototype = prototype;
        }

        protected Long createSnapshot() {
            return IngredientComponentStorageCollectionWrapper.this.ingredientCollection.getQuantity(this.prototype);
        }

        protected void revertToSnapshot(Long snapshot) {
            Long oldQuantity = IngredientComponentStorageCollectionWrapper.this.ingredientCollection.getQuantity(this.prototype);
            IngredientComponentStorageCollectionWrapper.this.ingredientCollection.setQuantity(this.prototype, snapshot);
            IngredientComponentStorageCollectionWrapper.this.quantity += snapshot - oldQuantity;
        }

        protected void onRootCommit(Long originalState) {
            super.onRootCommit((Object)originalState);
            IngredientComponentStorageCollectionWrapper.this.snapshotJournals.remove(this.prototype);
        }
    }
}

