/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.storage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientListMutable;

public class IngredientComponentStorageSlottedCollectionWrapper<T, M>
implements IIngredientComponentStorageSlotted<T, M> {
    private final IIngredientListMutable<T, M> ingredientCollection;
    private final long maxSlotQuantity;
    private final long rateLimit;
    private final Int2ObjectMap<SlotJournal> snapshotJournals;
    private long quantity;

    public IngredientComponentStorageSlottedCollectionWrapper(IIngredientListMutable<T, M> ingredientCollection, long maxSlotQuantity, long rateLimit) {
        this.ingredientCollection = ingredientCollection;
        this.maxSlotQuantity = maxSlotQuantity;
        this.rateLimit = rateLimit;
        this.snapshotJournals = new Int2ObjectOpenHashMap();
        this.quantity = 0L;
    }

    public int getSlots() {
        return this.ingredientCollection.size();
    }

    public T getSlotContents(int slot) {
        return this.ingredientCollection.get(slot);
    }

    public long getMaxQuantity(int slot) {
        return this.maxSlotQuantity;
    }

    T rateLimit(T instance, long allowedQuantity) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        long quantity = matcher.getQuantity(instance);
        long actualQuantity = Math.min(quantity, Math.min(allowedQuantity, this.rateLimit));
        if (actualQuantity == quantity) {
            return instance;
        }
        return (T)matcher.withQuantity(instance, actualQuantity);
    }

    SlotJournal getSnapshotJournal(int slot) {
        SlotJournal snapshotJournal = (SlotJournal)((Object)this.snapshotJournals.get(slot));
        if (snapshotJournal == null) {
            snapshotJournal = new SlotJournal(slot);
            this.snapshotJournals.put(slot, (Object)snapshotJournal);
        }
        return snapshotJournal;
    }

    public T insert(int slot, @Nonnull T ingredient, TransactionContext transaction) {
        Object contained;
        T insertingIngredient = this.rateLimit(ingredient, this.getMaxQuantity() - this.quantity);
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (!matcher.isEmpty(insertingIngredient) && (matcher.isEmpty(contained = this.ingredientCollection.get(slot)) || matcher.matches(ingredient, contained, matcher.getExactMatchNoQuantityCondition()))) {
            long addQuantity = Math.min(this.getMaxQuantity(slot) - matcher.getQuantity(contained), matcher.getQuantity(insertingIngredient));
            this.getSnapshotJournal(slot).updateSnapshots(transaction);
            this.ingredientCollection.set(slot, matcher.withQuantity(ingredient, matcher.getQuantity(contained) + addQuantity));
            this.quantity += addQuantity;
            return (T)matcher.withQuantity(insertingIngredient, matcher.getQuantity(ingredient) - addQuantity);
        }
        return ingredient;
    }

    public T extract(int slot, long maxQuantity, TransactionContext transaction) {
        Object contained;
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        if (!matcher.isEmpty(contained = this.ingredientCollection.get(slot))) {
            Object extractingIngredient = this.rateLimit(contained, maxQuantity);
            this.getSnapshotJournal(slot).updateSnapshots(transaction);
            long removeQuantity = matcher.getQuantity(extractingIngredient);
            this.ingredientCollection.set(slot, matcher.withQuantity(contained, matcher.getQuantity(contained) - removeQuantity));
            this.quantity -= removeQuantity;
            return extractingIngredient;
        }
        return (T)matcher.getEmptyInstance();
    }

    public IngredientComponent<T, M> getComponent() {
        return this.ingredientCollection.getComponent();
    }

    public Iterator<T> iterator() {
        return this.ingredientCollection.iterator();
    }

    public Iterator<T> iterator(@Nonnull T prototype, M matchCondition) {
        return this.ingredientCollection.iterator(prototype, matchCondition);
    }

    public long getMaxQuantity() {
        return (long)this.getSlots() * this.maxSlotQuantity;
    }

    public T insert(@Nonnull T ingredient, TransactionContext transaction) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        long givenQuantity = matcher.getQuantity(ingredient);
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.getSnapshotJournal(slot).updateSnapshots(transaction);
            try (Transaction tx = Transaction.open((TransactionContext)transaction);){
                T insertRemaining = this.insert(slot, ingredient, (TransactionContext)tx);
                if (matcher.getQuantity(insertRemaining) == givenQuantity) continue;
                tx.commit();
                T t = insertRemaining;
                return t;
            }
        }
        return ingredient;
    }

    public T extract(@Nonnull T prototype, M matchCondition, TransactionContext transaction) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            Object extractingIngredient;
            Object contained = this.ingredientCollection.get(slot);
            if (matcher.isEmpty(contained) || !matcher.matches(contained, prototype, matchCondition) || !matcher.matches(prototype, extractingIngredient = this.rateLimit(contained, matcher.getQuantity(prototype)), matchCondition)) continue;
            this.getSnapshotJournal(slot).updateSnapshots(transaction);
            long removeQuantity = matcher.getQuantity(extractingIngredient);
            this.ingredientCollection.set(slot, matcher.withQuantity(contained, matcher.getQuantity(contained) - removeQuantity));
            this.quantity -= removeQuantity;
            return extractingIngredient;
        }
        return (T)matcher.getEmptyInstance();
    }

    public T extract(long maxQuantity, TransactionContext transaction) {
        IIngredientMatcher matcher = this.getComponent().getMatcher();
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            this.getSnapshotJournal(slot).updateSnapshots(transaction);
            try (Transaction tx = Transaction.open((TransactionContext)transaction);){
                int extracted = this.extract((T)slot, (M)maxQuantity, (TransactionContext)tx);
                if (matcher.isEmpty((Object)extracted)) continue;
                tx.commit();
                int n = extracted;
                return n;
            }
        }
        return (T)matcher.getEmptyInstance();
    }

    private class SlotJournal
    extends SnapshotJournal<T> {
        private final int index;

        private SlotJournal(int index) {
            this.index = index;
        }

        protected T createSnapshot() {
            return IngredientComponentStorageSlottedCollectionWrapper.this.getComponent().getMatcher().copy(IngredientComponentStorageSlottedCollectionWrapper.this.ingredientCollection.get(this.index));
        }

        protected void revertToSnapshot(T snapshot) {
            Object oldStack = IngredientComponentStorageSlottedCollectionWrapper.this.ingredientCollection.get(this.index);
            IngredientComponentStorageSlottedCollectionWrapper.this.ingredientCollection.set(this.index, snapshot);
            long oldQuantity = IngredientComponentStorageSlottedCollectionWrapper.this.getComponent().getMatcher().getQuantity(oldStack);
            IngredientComponentStorageSlottedCollectionWrapper.this.quantity += IngredientComponentStorageSlottedCollectionWrapper.this.getComponent().getMatcher().getQuantity(snapshot) - oldQuantity;
        }

        protected void onRootCommit(T originalState) {
            super.onRootCommit(originalState);
            IngredientComponentStorageSlottedCollectionWrapper.this.snapshotJournals.remove(this.index);
        }
    }
}

