/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.storage;

import javax.annotation.Nonnull;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.ingredient.storage.IngredientComponentStorageWrapped;

public class IngredientComponentStorageSlottedWrapped<T, M>
extends IngredientComponentStorageWrapped<T, M>
implements IIngredientComponentStorageSlotted<T, M> {
    private final IIngredientComponentStorageSlotted<T, M> ingredientComponentStorageSlotted;

    public IngredientComponentStorageSlottedWrapped(IIngredientComponentStorageSlotted<T, M> ingredientComponentStorageSlotted, boolean iterate, boolean insert, boolean extract) {
        super(ingredientComponentStorageSlotted, iterate, insert, extract);
        this.ingredientComponentStorageSlotted = ingredientComponentStorageSlotted;
    }

    @Override
    protected IIngredientComponentStorageSlotted<T, M> getIngredientComponentStorage() {
        return this.ingredientComponentStorageSlotted;
    }

    public int getSlots() {
        if (!this.isRead()) {
            return 0;
        }
        return this.getIngredientComponentStorage().getSlots();
    }

    public T getSlotContents(int slot) {
        if (!this.isRead()) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        return (T)this.getIngredientComponentStorage().getSlotContents(slot);
    }

    public long getMaxQuantity(int slot) {
        if (!this.isRead()) {
            return 0L;
        }
        return this.getIngredientComponentStorage().getMaxQuantity(slot);
    }

    public T insert(int slot, @Nonnull T ingredient, TransactionContext transaction) {
        if (!this.isInsert()) {
            return ingredient;
        }
        return (T)this.getIngredientComponentStorage().insert(slot, ingredient, transaction);
    }

    @Override
    public T extract(int slot, long maxQuantity, TransactionContext transaction) {
        if (!this.isExtract()) {
            return (T)this.getComponent().getMatcher().getEmptyInstance();
        }
        return (T)this.getIngredientComponentStorage().extract(slot, maxQuantity, transaction);
    }
}

