/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.IInventoryLocation;
import org.cyclops.cyclopscore.inventory.InventoryLocations;

public record ItemLocation(IInventoryLocation inventoryLocation, int slot) {
    public ItemStack getItemStack(Player player) {
        return this.inventoryLocation().getItemInSlot(player, this.slot);
    }

    public void setItemStack(Player player, ItemStack itemStack) {
        this.inventoryLocation().setItemInSlot(player, this.slot, itemStack);
    }

    public static void writeToPacketBuffer(FriendlyByteBuf packetBuffer, ItemLocation location) {
        packetBuffer.writeIdentifier(location.inventoryLocation().getUniqueName());
        packetBuffer.writeInt(location.slot());
    }

    public static ItemLocation readFromPacketBuffer(FriendlyByteBuf packetBuffer) {
        IInventoryLocation inventoryLocation = InventoryLocations.REGISTRY.get(packetBuffer.readIdentifier());
        int slot = packetBuffer.readInt();
        return new ItemLocation(inventoryLocation, slot);
    }
}

