/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.RegistryEntries;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class NBTSimpleInventoryItemStack
extends SimpleInventory {
    protected final ItemAccess itemAccess;
    protected final String tagName;

    public NBTSimpleInventoryItemStack(ItemAccess itemAccess, int size, int stackLimit, String tagName) {
        super(size, stackLimit);
        this.itemAccess = itemAccess;
        this.tagName = tagName;
        SimpleInventory contents = (SimpleInventory)itemAccess.getResource().get(RegistryEntries.COMPONENT_INVENTORY);
        if (contents != null) {
            for (int i = 0; i < contents.getContainerSize(); ++i) {
                this.setItem(i, contents.getItem(i));
            }
        }
    }

    @Override
    public void setChanged() {
        try (Transaction tx = Transaction.openRoot();){
            this.itemAccess.exchange(this.itemAccess.getResource().with(RegistryEntries.COMPONENT_INVENTORY, (Object)this), this.itemAccess.getAmount(), (TransactionContext)tx);
            tx.commit();
        }
    }

    @Override
    public void readFromNBT(ValueInput data, String tagName) {
        IModHelpers.get().getInventoryHelpers().readFromNBT(this, data, tagName);
    }

    @Override
    public void writeToNBT(ValueOutput data, String tagName) {
        IModHelpers.get().getInventoryHelpers().writeToNBT(this, data, tagName);
    }
}

