/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.Identifier;
import org.cyclops.cyclopscore.inventory.IInventoryLocation;
import org.cyclops.cyclopscore.inventory.IRegistryInventoryLocation;
import org.jetbrains.annotations.Nullable;

public class RegistryInventoryLocation
implements IRegistryInventoryLocation {
    private static RegistryInventoryLocation INSTANCE = new RegistryInventoryLocation();
    public Map<String, IInventoryLocation> registry = Maps.newHashMap();

    public static RegistryInventoryLocation getInstance() {
        return INSTANCE;
    }

    private RegistryInventoryLocation() {
    }

    @Override
    public void register(IInventoryLocation inventoryLocation) {
        this.registry.put(inventoryLocation.getUniqueName().toString(), inventoryLocation);
    }

    @Override
    @Nullable
    public IInventoryLocation get(Identifier uniqueName) {
        return this.registry.get(uniqueName.toString());
    }

    @Override
    public Collection<IInventoryLocation> values() {
        return this.registry.values();
    }
}

