/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.EntityHelpers;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;

public class SendPlayerNbtPacket
extends PacketCodec<SendPlayerNbtPacket> {
    public static final CustomPacketPayload.Type<SendPlayerNbtPacket> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"cyclopscore", (String)"send_player_nbt"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SendPlayerNbtPacket> CODEC = SendPlayerNbtPacket.getCodec(SendPlayerNbtPacket::new);
    @CodecField
    private CompoundTag nbtData;

    public SendPlayerNbtPacket() {
        super(TYPE);
    }

    public SendPlayerNbtPacket(Player player) {
        this();
        this.nbtData = EntityHelpers.getPersistedPlayerNbt(player);
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void actionClient(Level level, Player player) {
        player.getPersistentData().put("PlayerPersisted", (Tag)this.nbtData);
    }

    @Override
    public void actionServer(Level level, ServerPlayer player) {
    }
}

