/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.block;

import com.mojang.logging.LogUtils;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.HitResult;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.slf4j.Logger;

public abstract class BlockWithEntity
extends BaseEntityBlock {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntity> blockEntitySupplier;

    public BlockWithEntity(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, ? extends CyclopsBlockEntity> blockEntitySupplier) {
        super(properties);
        this.blockEntitySupplier = blockEntitySupplier;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return this.blockEntitySupplier.apply(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState playerWillDestroy(Level world, BlockPos blockPos, BlockState blockState, Player player) {
        return super.playerWillDestroy(world, blockPos, blockState, player);
    }

    protected ItemStack getDroppedItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos blockPos, Player player, ItemStack originalItemStack) {
        return originalItemStack;
    }

    protected CompoundTag getDroppedItemStackNbt(BlockState state, HitResult target, BlockGetter world, BlockPos blockPos, Player player, ItemStack itemStack, CyclopsBlockEntity blockEntity) {
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(blockEntity.problemPath(), LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)problemReporter, (HolderLookup.Provider)player.level().registryAccess());
            blockEntity.writeToItemStack((ValueOutput)tagValueOutput);
            CompoundTag compoundTag = tagValueOutput.buildResult();
            return compoundTag;
        }
    }

    public boolean isPersistNbt() {
        return false;
    }
}

