/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.ItemDecoratorHandler;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.jetbrains.annotations.Nullable;

public class GuiGraphicsExtended {
    private final GuiGraphics guiGraphics;

    public GuiGraphicsExtended(GuiGraphics guiGraphics) {
        this.guiGraphics = guiGraphics;
    }

    public void drawSlotText(Font font, @javax.annotation.Nullable String text, int x, int y) {
        this.guiGraphics.pose().pushMatrix();
        this.guiGraphics.pose().translate(0.0f, 0.0f);
        float scale = 0.5f;
        this.guiGraphics.pose().scale(scale, scale);
        this.guiGraphics.drawString(font, text, (int)((float)(x + 19 - 2) / scale - (float)font.width(text)), (int)((float)(y + 6 + 6) / scale), -1, true);
        this.guiGraphics.pose().popMatrix();
    }

    private void renderItemCount(Font font, ItemStack stack, int x, int y, @javax.annotation.Nullable String text) {
        if (stack.getCount() != 1 || text != null) {
            String s = text == null ? IModHelpers.get().getGuiHelpers().quantityToScaledString(stack.getCount()) : text;
            this.drawSlotText(font, s, x, y);
        }
    }

    public void renderItemDecorations(Font font, ItemStack stack, int x, int y) {
        this.renderItemDecorations(font, stack, x, y, null);
    }

    public void renderItemDecorations(Font font, ItemStack stack, int x, int y, @Nullable String text) {
        if (!stack.isEmpty()) {
            this.guiGraphics.pose().pushMatrix();
            this.guiGraphics.renderItemBar(stack, x, y);
            this.guiGraphics.renderItemCooldown(stack, x, y);
            this.renderItemCount(font, stack, x, y, text);
            this.guiGraphics.pose().popMatrix();
            ItemDecoratorHandler.of((ItemStack)stack).render(this.guiGraphics, font, stack, x, y);
        }
    }
}

