/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.fluid.Tank;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SingleUseTank
extends Tank {
    public static final String NBT_ACCEPTED_FLUID = "acceptedFluid";
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private Fluid acceptedFluid;

    public SingleUseTank(int capacity) {
        super(capacity);
        this.setAcceptedFluid(Fluids.EMPTY);
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int insert(int index, FluidResource resource, int amount, TransactionContext transaction) {
        if (this.acceptedFluid != Fluids.EMPTY && !resource.is((Object)this.acceptedFluid)) {
            return 0;
        }
        return super.insert(index, (Resource)resource, amount, transaction);
    }

    protected void onContentsChanged(int index, FluidStack previousContents) {
        super.onContentsChanged(index, (Object)previousContents);
        if (this.getFluid() != previousContents) {
            this.sendUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUpdate() {
        LinkedList dirtyMarkListeners;
        SingleUseTank singleUseTank = this;
        synchronized (singleUseTank) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    public void reset() {
        this.acceptedFluid = Fluids.EMPTY;
    }

    public void setAcceptedFluid(Fluid fluid) {
        this.acceptedFluid = Objects.requireNonNull(fluid);
    }

    public Fluid getAcceptedFluid() {
        return this.acceptedFluid;
    }

    @Override
    public void serializeTank(ValueOutput output) {
        super.serializeTank(output);
        output.putString(NBT_ACCEPTED_FLUID, BuiltInRegistries.FLUID.getKey((Object)this.acceptedFluid).toString());
    }

    @Override
    public void deserializeTank(ValueInput input) {
        super.deserializeTank(input);
        this.setAcceptedFluid((Fluid)BuiltInRegistries.FLUID.getValue(ResourceLocation.parse((String)((String)input.getString(NBT_ACCEPTED_FLUID).orElseThrow()))));
    }
}

