/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.base.Predicates;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.resource.ResourceStack;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.IFluidHelpersNeoForge;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.inventory.ItemAccessItemLocation;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.jetbrains.annotations.Nullable;

public class FluidHelpersNeoForge
implements IFluidHelpersNeoForge {
    @Override
    public int getBucketVolume() {
        return 1000;
    }

    @Override
    public int getAmount(FluidStack fluidStack) {
        return fluidStack.getAmount();
    }

    @Override
    public FluidStack copy(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return fluidStack.copy();
    }

    @Override
    public FluidStack getFluid(@Nullable ResourceHandler<FluidResource> fluidHandler) {
        return fluidHandler != null ? FluidUtil.getStack(fluidHandler, (int)0) : FluidStack.EMPTY;
    }

    @Override
    public boolean hasFluid(@Nullable ResourceHandler<FluidResource> fluidHandler) {
        return !this.getFluid(fluidHandler).isEmpty();
    }

    @Override
    public long getCapacity(@Nullable ResourceHandler<FluidResource> fluidHandler) {
        long capacity = 0L;
        if (fluidHandler != null) {
            for (int i = 0; i < fluidHandler.size(); ++i) {
                capacity += fluidHandler.getCapacityAsLong(i, (Resource)((FluidResource)fluidHandler.getResource(i)));
            }
        }
        return capacity;
    }

    @Override
    public Optional<IFluidHandlerCapacity> getFluidHandlerItemCapacity(ItemAccess itemAccess) {
        return Optional.ofNullable((IFluidHandlerCapacity)itemAccess.getCapability(Capabilities.Item.FLUID_HANDLER_CAPACITY));
    }

    @Override
    public FluidStack extractFromInventory(int amount, @Nullable ItemStack blacklistedStack, @Nullable Fluid fluidWhitelist, Player player, Transaction transaction) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        Wrapper<FluidStack> drained = new Wrapper<FluidStack>(FluidStack.EMPTY);
        Wrapper<Integer> amountHolder = new Wrapper<Integer>(amount);
        while (it.hasNext() && amountHolder.get() > 0) {
            int thisDrained;
            FluidStack totalFluid;
            ItemLocation currentLocation = it.nextIndexed();
            ItemAccessItemLocation current = new ItemAccessItemLocation(player, currentLocation);
            ResourceHandler fluidHandler = (ResourceHandler)current.getCapability(Capabilities.Fluid.ITEM);
            if (currentLocation.getItemStack(player) == blacklistedStack || fluidHandler == null || (totalFluid = this.getFluid((ResourceHandler<FluidResource>)fluidHandler)).isEmpty() || fluidWhitelist != null && totalFluid.getFluid() != fluidWhitelist || (thisDrained = fluidHandler.extract((Resource)FluidResource.of((FluidStack)totalFluid), amountHolder.get().intValue(), (TransactionContext)transaction)) <= 0) continue;
            if (drained.get().isEmpty()) {
                drained.set(totalFluid.copyWithAmount(thisDrained));
            } else {
                drained.get().setAmount(drained.get().getAmount() + thisDrained);
            }
            amountHolder.set(amountHolder.get() - thisDrained);
        }
        if (drained.get() != null && drained.get().getAmount() == 0) {
            drained.set(FluidStack.EMPTY);
        }
        return drained.get();
    }

    @Override
    public FluidStack extractFromItemOrInventory(int amount, ItemStack itemStack, @Nullable Player player, Transaction transaction) {
        FluidStack otherDrained;
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        ItemAccess itemAccess = ItemAccess.forStack((ItemStack)itemStack);
        ResourceHandler fluidHandler = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
        if (fluidHandler == null) {
            return FluidStack.EMPTY;
        }
        FluidResource fluidResource = FluidResource.of((FluidStack)this.getFluid((ResourceHandler<FluidResource>)fluidHandler));
        int drained = fluidHandler.extract((Resource)fluidResource, amount, (TransactionContext)transaction);
        if (drained == amount) {
            return fluidResource.toStack(drained);
        }
        int toDrain = amount - drained;
        FluidStack fluidStack = otherDrained = player == null ? null : this.extractFromInventory(toDrain, itemStack, this.getFluid((ResourceHandler<FluidResource>)fluidHandler).getFluid(), player, transaction);
        if (otherDrained == null) {
            return fluidResource.toStack(drained);
        }
        otherDrained.setAmount(otherDrained.getAmount() + drained);
        return otherDrained;
    }

    @Override
    public FluidStack placeOrPickUpFluid(Player player, InteractionHand hand, Level world, BlockPos blockPos, Direction side) {
        ItemAccess itemAccess = ItemAccess.forPlayerInteraction((Player)player, (InteractionHand)hand);
        return this.getFluidHandlerItemCapacity(itemAccess).map(fluidHandler -> {
            FluidStack resultPlace;
            int drained;
            FluidStack resultPickUp;
            FluidStack fluidStack = FluidUtil.getFirstStackContained((ItemStack)itemAccess.getResource().toStack());
            if ((fluidStack.isEmpty() || fluidStack.getAmount() + IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume() <= fluidHandler.getTankCapacity(0)) && !(resultPickUp = FluidUtil.tryPickupFluid((ResourceHandler)fluidHandler, (Player)player, (Level)world, (BlockPos)blockPos, (Direction)side)).isEmpty()) {
                return resultPickUp;
            }
            try (Transaction tx = Transaction.openRoot();){
                drained = fluidHandler.extract((Resource)FluidResource.of((FluidStack)fluidStack), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), (TransactionContext)tx);
            }
            if (drained > 0 && !(resultPlace = FluidUtil.tryPlaceFluid((ResourceHandler)fluidHandler, (Player)player, (Level)world, (InteractionHand)hand, (BlockPos)blockPos)).isEmpty()) {
                return resultPlace;
            }
            return FluidStack.EMPTY;
        }).orElse(FluidStack.EMPTY);
    }

    @Override
    public boolean canExtract(ResourceHandler<FluidResource> fluidHandler) {
        for (int index = 0; index < fluidHandler.size(); ++index) {
            try (Transaction tx = Transaction.openRoot();){
                if (fluidHandler.extract(index, (Resource)((FluidResource)fluidHandler.getResource(index)), Integer.MAX_VALUE, (TransactionContext)tx) <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean canInsert(ResourceHandler<FluidResource> fluidHandler, FluidStack fluidStack) {
        FluidResource resource = FluidResource.of((FluidStack)fluidStack);
        for (int index = 0; index < fluidHandler.size(); ++index) {
            try (Transaction tx = Transaction.openRoot();){
                if (fluidHandler.insert(index, (Resource)resource, fluidStack.getAmount(), (TransactionContext)tx) <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public FluidStack move(ResourceHandler<FluidResource> source, ResourceHandler<FluidResource> destination, int maxAmount, @Nullable Player player, boolean emptySound, boolean simulate) {
        SoundEvent soundevent;
        ResourceStack moved;
        try (Transaction tx = Transaction.openRoot();){
            moved = ResourceHandlerUtil.moveFirst(source, destination, (Predicate)Predicates.alwaysTrue(), (int)maxAmount, (TransactionContext)tx);
            if (!simulate) {
                tx.commit();
            }
        }
        if (moved == null) {
            return FluidStack.EMPTY;
        }
        FluidStack movedStack = ((FluidResource)moved.resource()).toStack(moved.amount());
        if (!simulate && player != null && (soundevent = ((FluidResource)moved.resource()).getFluidType().getSound(movedStack, emptySound ? SoundActions.BUCKET_EMPTY : SoundActions.BUCKET_FILL)) != null) {
            player.level().playSound(null, player.getX(), player.getY() + 0.5, player.getZ(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return movedStack;
    }
}

