/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Maps;
import com.mojang.math.Transformation;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.model.data.ModelProperty;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class ModelHelpers {
    public static final ItemTransform THIRD_PERSON_RIGHT_HAND = new ItemTransform((Vector3fc)new Vector3f(70.0f, 45.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransform THIRD_PERSON_LEFT_HAND = new ItemTransform((Vector3fc)new Vector3f(70.0f, 45.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransform FIRST_PERSON_RIGHT_HAND = new ItemTransform((Vector3fc)new Vector3f(0.0f, 45.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.4f, 0.4f, 0.4f));
    public static final ItemTransform FIRST_PERSON_LEFT_HAND = new ItemTransform((Vector3fc)new Vector3f(0.0f, 255.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.4f, 0.4f, 0.4f));
    public static final ItemTransform HEAD = ItemTransform.NO_TRANSFORM;
    public static final ItemTransform GROUND = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.375f, 0.375f, 0.375f));
    public static final ItemTransform FIXED = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f));
    public static final ItemTransform ON_SHELF = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f));
    public static final ItemTransform GUI = new ItemTransform((Vector3fc)new Vector3f(30.0f, 225.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.625f, 0.625f, 0.625f));
    public static final ItemTransforms DEFAULT_CAMERA_TRANSFORMS = new ItemTransforms(THIRD_PERSON_RIGHT_HAND, THIRD_PERSON_LEFT_HAND, FIRST_PERSON_RIGHT_HAND, FIRST_PERSON_LEFT_HAND, HEAD, GUI, GROUND, FIXED, ON_SHELF);
    public static final Map<ItemDisplayContext, ModelState> DEFAULT_MODEL_STATES = ModelHelpers.convertModelState(DEFAULT_CAMERA_TRANSFORMS);
    public static final ItemTransform THIRD_PERSON_RIGHT_HAND_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.55f, 0.55f, 0.55f));
    public static final ItemTransform THIRD_PERSON_LEFT_HAND_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.55f, 0.55f, 0.55f));
    public static final ItemTransform FIRST_PERSON_RIGHT_HAND_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, -90.0f, 25.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.68f, 0.68f, 0.68f));
    public static final ItemTransform FIRST_PERSON_LEFT_HAND_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, -90.0f, 25.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.68f, 0.68f, 0.68f));
    public static final ItemTransform HEAD_ITEM = ItemTransform.NO_TRANSFORM;
    public static final ItemTransform GROUND_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.5f, 0.5f, 0.5f));
    public static final ItemTransform FIXED_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f));
    public static final ItemTransform ON_SHELF_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f));
    public static final ItemTransform GUI_ITEM = new ItemTransform((Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(0.0f, 0.0f, 0.0f), (Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f));
    public static final ItemTransforms DEFAULT_CAMERA_TRANSFORMS_ITEM = new ItemTransforms(THIRD_PERSON_RIGHT_HAND_ITEM, THIRD_PERSON_LEFT_HAND_ITEM, FIRST_PERSON_RIGHT_HAND_ITEM, FIRST_PERSON_LEFT_HAND_ITEM, HEAD_ITEM, GUI_ITEM, GROUND_ITEM, FIXED_ITEM, ON_SHELF_ITEM);
    public static final Map<Direction, List<BakedQuad>> EMPTY_FACE_QUADS = Maps.newHashMap();

    public static BlockModel loadModelBlock(ResourceLocation modelLocation) throws IOException {
        Resource resource = (Resource)Minecraft.getInstance().getResourceManager().getResource(ResourceLocation.fromNamespaceAndPath((String)modelLocation.getNamespace(), (String)(modelLocation.getPath() + ".json"))).get();
        return BlockModel.fromStream((Reader)resource.openAsReader());
    }

    public static <T> T getSafeProperty(@Nullable ModelData modelData, ModelProperty<T> property, T fallback) {
        Object value;
        if (modelData == null) {
            return fallback;
        }
        try {
            value = modelData.get(property);
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
        if (value == null) {
            return fallback;
        }
        return (T)value;
    }

    public static ItemTransforms modifyDefaultTransforms(Map<ItemDisplayContext, ItemTransform> overrides) {
        return new ItemTransforms(overrides.getOrDefault(ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, THIRD_PERSON_RIGHT_HAND), overrides.getOrDefault(ItemDisplayContext.THIRD_PERSON_LEFT_HAND, THIRD_PERSON_LEFT_HAND), overrides.getOrDefault(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, FIRST_PERSON_RIGHT_HAND), overrides.getOrDefault(ItemDisplayContext.FIRST_PERSON_LEFT_HAND, FIRST_PERSON_LEFT_HAND), overrides.getOrDefault(ItemDisplayContext.HEAD, HEAD), overrides.getOrDefault(ItemDisplayContext.GUI, GUI), overrides.getOrDefault(ItemDisplayContext.GROUND, GROUND), overrides.getOrDefault(ItemDisplayContext.FIXED, FIXED), overrides.getOrDefault(ItemDisplayContext.ON_SHELF, ON_SHELF));
    }

    private static Map<ItemDisplayContext, ModelState> convertModelState(ItemTransforms itemTransforms) {
        EnumMap<ItemDisplayContext, ModelState> map = new EnumMap<ItemDisplayContext, ModelState>(ItemDisplayContext.class);
        for (ItemDisplayContext key : ItemDisplayContext.values()) {
            ItemTransform itemTransform = itemTransforms.getTransform(key);
            final Transformation transformation = new Transformation(new Vector3f(itemTransform.translation()), ModelHelpers.eulerToQuaternion(itemTransform.rotation()), new Vector3f(itemTransform.scale()), ModelHelpers.eulerToQuaternion(itemTransform.rightRotation()));
            map.put(key, new ModelState(){

                public Transformation transformation() {
                    return transformation;
                }
            });
        }
        return map;
    }

    public static Quaternionf eulerToQuaternion(Vector3fc euler) {
        return new Quaternionf().rotationXYZ((float)Math.toRadians(euler.x()), (float)Math.toRadians(euler.y()), (float)Math.toRadians(euler.z()));
    }

    public static BlockStateModel bakeSingleBlockStateModel(ModelBaker baker, ResourceLocation id, ModelState modelState) {
        return new SingleVariant((BlockModelPart)SimpleModelWrapper.bake((ModelBaker)baker, (ResourceLocation)id, (ModelState)modelState));
    }

    static {
        for (Direction facing : Direction.values()) {
            EMPTY_FACE_QUADS.put(facing, Collections.emptyList());
        }
    }
}

