/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.inventory.IInventoryIndexReference;

public class IndexedItemResourceHandler
implements ResourceHandler<ItemResource> {
    private final IInventoryIndexReference indexReference;
    private final ResourceHandler<ItemResource> resourceHandler;

    public IndexedItemResourceHandler(IInventoryIndexReference indexReference, ResourceHandler<ItemResource> resourceHandler) {
        this.indexReference = indexReference;
        this.resourceHandler = resourceHandler;
    }

    public int size() {
        return this.resourceHandler.size();
    }

    public ItemResource getResource(int index) {
        return (ItemResource)this.resourceHandler.getResource(index);
    }

    public long getAmountAsLong(int index) {
        return this.resourceHandler.getAmountAsLong(index);
    }

    public int getAmountAsInt(int index) {
        return this.resourceHandler.getAmountAsInt(index);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        return this.resourceHandler.getCapacityAsLong(index, (Resource)resource);
    }

    public int getCapacityAsInt(int index, ItemResource resource) {
        return this.resourceHandler.getCapacityAsInt(index, (Resource)resource);
    }

    public boolean isValid(int index, ItemResource resource) {
        return this.resourceHandler.isValid(index, (Resource)resource);
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return this.resourceHandler.insert(index, (Resource)resource, amount, transaction);
    }

    protected PrimitiveIterator.OfInt getNonFullSlotsWithItemStack(ItemResource resource) {
        Map<Item, Int2ObjectMap<ItemStack>> items = this.indexReference.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(resource.getItem());
        if (stacks != null) {
            return stacks.int2ObjectEntrySet().stream().filter(entry -> ((ItemStack)entry.getValue()).getCount() < Math.min(this.indexReference.getInventoryReferenceStackLimit(), ((ItemStack)entry.getValue()).getMaxStackSize()) && resource.matches((ItemStack)entry.getValue())).mapToInt(Int2ObjectMap.Entry::getIntKey).iterator();
        }
        return IntStream.empty().iterator();
    }

    public int insert(ItemResource resource, int amount, TransactionContext transaction) {
        int amountOriginal = amount;
        PrimitiveIterator.OfInt itNonFull = this.getNonFullSlotsWithItemStack(resource);
        while (itNonFull.hasNext() && amount > 0) {
            int slot = itNonFull.nextInt();
            int inserted = this.insert(slot, resource, amount, transaction);
            amount -= inserted;
        }
        if (amount > 0) {
            PrimitiveIterator.OfInt itEmpty = this.indexReference.getEmptySlots();
            while (itEmpty.hasNext() && amount > 0) {
                int slot = itEmpty.nextInt();
                int inserted = this.insert(slot, resource, amount, transaction);
                amount -= inserted;
            }
        }
        return amountOriginal - amount;
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext transaction) {
        return this.resourceHandler.extract(index, (Resource)resource, amount, transaction);
    }

    protected PrimitiveIterator.OfInt getNonEmptySlotsWithItemStack(ItemResource resource) {
        Map<Item, Int2ObjectMap<ItemStack>> items = this.indexReference.getIndex();
        Int2ObjectMap<ItemStack> stacks = items.get(resource.getItem());
        if (stacks != null) {
            return stacks.int2ObjectEntrySet().stream().filter(entry -> resource.matches((ItemStack)entry.getValue())).mapToInt(Int2ObjectMap.Entry::getIntKey).iterator();
        }
        return IntStream.empty().iterator();
    }

    public int extract(ItemResource resource, int amount, TransactionContext transaction) {
        int slot;
        PrimitiveIterator.OfInt itSimulated = this.getNonEmptySlotsWithItemStack(resource);
        int extracted = 0;
        while (itSimulated.hasNext() && amount > 0 && (extracted += this.extract(slot = itSimulated.nextInt(), resource, amount - extracted, transaction)) < amount) {
        }
        return extracted;
    }
}

