/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.inventory.ItemLocation;

public class ItemAccessItemLocation
implements ItemAccess {
    private final Player player;
    private final ItemLocation itemLocation;

    public ItemAccessItemLocation(Player player, ItemLocation itemLocation) {
        this.player = player;
        this.itemLocation = itemLocation;
    }

    public ItemResource getResource() {
        return ItemResource.of((ItemStack)this.itemLocation.getItemStack(this.player));
    }

    public int getAmount() {
        return this.itemLocation.getItemStack(this.player).getCount();
    }

    public int insert(ItemResource itemResource, int amount, TransactionContext transactionContext) {
        this.itemLocation.setItemStack(this.player, itemResource.toStack(amount));
        return amount;
    }

    public int extract(ItemResource itemResource, int amount, TransactionContext transactionContext) {
        this.itemLocation.setItemStack(this.player, ItemStack.EMPTY);
        return amount;
    }
}

