/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.fluid.FluidUtil;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerCapacity;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;
import org.cyclops.cyclopscore.item.IInformationProvider;

public class DamageIndicatedItemComponent {
    public DamageIndicatedItemFluidContainer item;

    public DamageIndicatedItemComponent(DamageIndicatedItemFluidContainer item) {
        this.item = item;
    }

    public void fillDefaultCreativeTabEntries(NonNullList<ItemStack> items, Fluid fluid) {
        ItemAccess itemStackFullAccess = ItemAccess.forStack((ItemStack)new ItemStack((ItemLike)this.item));
        IFluidHandlerCapacity fluidHanderFull = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(itemStackFullAccess).orElse(null);
        if (fluidHanderFull != null) {
            try (Transaction tx = Transaction.openRoot();){
                fluidHanderFull.insert((Resource)FluidResource.of((Fluid)fluid), fluidHanderFull.getTankCapacity(0), (TransactionContext)tx);
                tx.commit();
            }
        }
        items.add((Object)itemStackFullAccess.getResource().toStack());
        ItemStack itemStackEmpty = new ItemStack((ItemLike)this.item);
        items.add((Object)itemStackEmpty);
    }

    public MutableComponent getInfo(ItemStack itemStack) {
        IFluidHandlerCapacity fluidHander;
        int amount = 0;
        FluidStack fluidStack = FluidUtil.getFirstStackContained((ItemStack)itemStack);
        if (!fluidStack.isEmpty()) {
            amount = fluidStack.getAmount();
        }
        return DamageIndicatedItemComponent.getInfo(fluidStack, amount, (fluidHander = (IFluidHandlerCapacity)IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(ItemAccess.forStack((ItemStack)itemStack)).orElse(null)) == null ? 0 : fluidHander.getTankCapacity(0));
    }

    public static MutableComponent getInfo(FluidStack fluidStack, int amount, int capacity) {
        MutableComponent prefix = Component.literal((String)"");
        if (!fluidStack.isEmpty()) {
            prefix = fluidStack.getHoverName().copy().append(": ");
        }
        return prefix.append(String.format(Locale.ROOT, "%,d", amount)).append(" / ").append(String.format(Locale.ROOT, "%,d", capacity)).append(" mB");
    }

    public void addInformation(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)((IInformationProvider)itemStack.getItem()).getInfo(itemStack).setStyle(Style.EMPTY.withColor(IInformationProvider.ITEM_PREFIX)));
    }

    public int getDurability(ItemStack itemStack) {
        FluidStack fluidStack = FluidUtil.getFirstStackContained((ItemStack)itemStack);
        IFluidHandlerCapacity fluidHander = IModHelpersNeoForge.get().getFluidHelpers().getFluidHandlerItemCapacity(ItemAccess.forStack((ItemStack)itemStack)).orElse(null);
        double capacity = fluidHander == null ? 0.0 : (double)fluidHander.getTankCapacity(0);
        double amount = IModHelpersNeoForge.get().getFluidHelpers().getAmount(fluidStack);
        return (int)Math.round(amount * 13.0 / capacity);
    }
}

