/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.cyclops.cyclopscore.Capabilities;
import org.cyclops.cyclopscore.CyclopsCoreNeoForge;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.cyclopscore.item.DamageIndicatedItemComponent;
import org.cyclops.cyclopscore.item.IInformationProvider;

public abstract class DamageIndicatedItemFluidContainer
extends Item
implements IInformationProvider {
    protected final int capacity;
    protected DamageIndicatedItemComponent component;
    protected final Supplier<Fluid> fluid;

    public DamageIndicatedItemFluidContainer(Item.Properties builder, int capacity, Supplier<Fluid> fluid) {
        super(builder);
        this.capacity = capacity;
        this.fluid = fluid;
        this.init();
        CyclopsCoreNeoForge._instance.getModEventBus().addListener(this::registerCapability);
    }

    private void registerCapability(RegisterCapabilitiesEvent event) {
        event.registerItem(Capabilities.Fluid.ITEM, (itemStack, context) -> new FluidHandlerItemCapacity((ItemAccess)context, this.capacity, this.getFluid()), new ItemLike[]{this});
        event.registerItem(Capabilities.Item.FLUID_HANDLER_CAPACITY, (itemStack, context) -> new FluidHandlerItemCapacity((ItemAccess)context, this.capacity, this.getFluid()), new ItemLike[]{this});
    }

    private void init() {
        this.component = new DamageIndicatedItemComponent(this);
    }

    public Collection<ItemStack> getDefaultCreativeTabEntries() {
        NonNullList list = NonNullList.create();
        this.component.fillDefaultCreativeTabEntries((NonNullList<ItemStack>)list, this.fluid.get());
        return list;
    }

    @Override
    public MutableComponent getInfo(ItemStack itemStack) {
        return this.component.getInfo(itemStack);
    }

    @Override
    public void provideInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        this.component.addInformation(itemStack, context, tooltipDisplay, tooltipAdder, flag);
        super.appendHoverText(itemStack, context, tooltipDisplay, tooltipAdder, flag);
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack itemStack) {
        return this.component.getDurability(itemStack);
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getBarWidth(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public Fluid getFluid() {
        return this.fluid.get();
    }

    public boolean canDrain(int amount, ItemStack itemStack) {
        ItemAccess itemAccess = ItemAccess.forStack((ItemStack)itemStack);
        ResourceHandler fluidHandler = (ResourceHandler)itemAccess.getCapability(Capabilities.Fluid.ITEM);
        if (fluidHandler == null) {
            return false;
        }
        try (Transaction tx = Transaction.openRoot();){
            int simulatedDrain = fluidHandler.extract((Resource)((FluidResource)fluidHandler.getResource(0)), amount, (TransactionContext)tx);
            boolean bl = simulatedDrain == amount;
            return bl;
        }
    }
}

